% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_Static.R
\name{DSC_Static}
\alias{DSC_Static}
\title{Create as Static Copy of a Clustering}
\usage{
DSC_Static(
  x,
  type = c("auto", "micro", "macro"),
  k_largest = NULL,
  min_weight = NULL
)
}
\arguments{
\item{x}{The clustering (a DSD object) to copy or a list with components \code{centers} (a data frame or matrix) and
\code{weights} (a vector with cluster weights).}

\item{type}{which clustering to copy.}

\item{k_largest}{only copy the k largest (highest weight) clusters.}

\item{min_weight}{only copy clusters with a weight larger or equal to
\code{min_weight}.}
}
\value{
An object of class \code{DSC_Static} (sub class of \link{DSC},
\link{DSC_R}). The list also contains either \link{DSC_Micro} or
\link{DSC_Macro} depending on what type of clustering was copied.
}
\description{
This representation cannot perform clustering anymore, but it also does not
need the supporting data structures. It only stores the cluster centers and
weights.
}
\examples{
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

dstream <- DSC_DStream(gridsize = 0.05)
update(dstream, stream, 500)
dstream
plot(dstream, stream)

# create a static copy of the clustering
static <- DSC_Static(dstream)
static
plot(static, stream)

# copy only the 5 largest clusters
static2 <- DSC_Static(dstream, k_largest = 5)
static2
plot(static2, stream)

# copy all clusters with a weight of at least .3
static3 <- DSC_Static(dstream, min_weight = .3)
static3
plot(static3, stream)

# create a manual clustering
static4 <- DSC_Static(list(
             centers = data.frame(X1 = c(1, 2), X2 = c(1, 2)),
             weights = c(1, 2)),
             type = "macro")
static4
plot(static4)
}
\seealso{
Other DSC: 
\code{\link{DSC_Macro}()},
\code{\link{DSC_Micro}()},
\code{\link{DSC_R}()},
\code{\link{DSC_TwoStage}()},
\code{\link{DSC}()},
\code{\link{animate_cluster}()},
\code{\link{evaluate.DSC}},
\code{\link{get_assignment}()},
\code{\link{plot.DSC}()},
\code{\link{predict}()},
\code{\link{prune_clusters}()},
\code{\link{read_saveDSC}},
\code{\link{recluster}()}
}
\author{
Michael Hahsler
}
\concept{DSC}
