% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate}
\alias{evaluate}
\alias{evaluate_static}
\alias{evaluate_stream}
\title{Evaluate a Data Stream Mining Task}
\usage{
evaluate_static(object, dsd, measure, n, ...)

evaluate_stream(object, dsd, measure, n, horizon, ..., verbose = FALSE)
}
\arguments{
\item{object}{The \link{DST} object that the evaluation measure is being requested
from.}

\item{dsd}{The \link{DSD} object used to create the test data.}

\item{measure}{Evaluation measure(s) to use. If missing then all available
measures are returned.}

\item{n}{The number of data points being requested.}

\item{...}{Further arguments.}

\item{horizon}{Evaluation is done using horizon many previous points (see
detail section).}

\item{verbose}{Report progress?}
}
\value{
\code{evaluate} returns an object of class \code{stream_eval} which
is a numeric vector of the values of the requested measures.
}
\description{
Calculate evaluation measures for a data stream mining task \link{DST} using
a data stream \link{DSD} object.
}
\details{
We provide two evaluation methods:
\itemize{
\item \code{evaluate_static()} evaluates the current \link{DST} model on new data without updating the model.
\item \code{evaluate_stream()} evaluates the \link{DST} model using
\emph{prequential error estimation} (see Gama, Sebastiao and Rodrigues; 2013). The data points
in the horizon are first used to calculate the evaluation measure and then
they are used for updating the cluster model. A horizon of ` means that each point is evaluated and
then used to update the model.
}

The evaluation measures depend on the task.
}
\references{
Joao Gama, Raquel Sebastiao, Pedro Pereira Rodrigues (2013). On
evaluating stream learning algorithms. \emph{Machine Learning,} March 2013,
Volume 90, Issue 3, pp 317-346.
}
\seealso{
Other DST: 
\code{\link{DSAggregate}()},
\code{\link{DSClassifier}()},
\code{\link{DSC}()},
\code{\link{DSF_Scale}()},
\code{\link{DSOutlier}()},
\code{\link{DST_Runner}()},
\code{\link{DST_WriteStream}()},
\code{\link{DST}()},
\code{\link{predict}()},
\code{\link{update}()}

Other evaluation: 
\code{\link{animate_cluster}()},
\code{\link{evaluate.DSC}}
}
\author{
Michael Hahsler
}
\concept{DST}
\concept{evaluation}
