% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.DSC.R
\name{plot.DSC}
\alias{plot.DSC}
\title{Plot Results of a Data Stream Clustering}
\usage{
\method{plot}{DSC}(
  x,
  dsd = NULL,
  n = 500,
  col_points = NULL,
  col_clusters = c("red", "blue", "green"),
  weights = TRUE,
  scale = c(1, 5),
  cex = 1,
  pch = NULL,
  method = c("pairs", "scatter", "pca"),
  dim = NULL,
  type = c("auto", "micro", "macro", "both", "none"),
  assignment = FALSE,
  transform = NULL,
  ...
)
}
\arguments{
\item{x}{the \link{DSC} object to be plotted.}

\item{dsd}{a \link{DSD} object to plot the data in the background.}

\item{n}{number of plots taken from \code{dsd} to plot.}

\item{col_points, col_clusters}{colors used for plotting.}

\item{weights}{if \code{TRUE} then the cluster weight is used for symbol size. Alternatively, a
vector with the size of the symbols for micro- and macro-clusters can be supplied.}

\item{scale}{range for the symbol sizes used.}

\item{cex}{size factor for symbols.}

\item{pch}{symbol type for points.}

\item{method}{method used for plotting: \code{"pairs"} (pairs plot), \code{"scatter"}
(scatter plot), \code{"pca"} (plot first 2 principal components).}

\item{dim}{an integer vector with the dimensions to plot. If \code{NULL}
then for methods \code{pairs} and \code{"pca"} all dimensions are used and
for \code{"scatter"} the first two dimensions are plotted.}

\item{type}{Plot micro clusters (\code{type = "micro"}), macro clusters
(\code{type = "macro"}), both micro and macro clusters (\code{type = "both"}).}

\item{assignment}{logical; show assignment area of micro-clusters.}

\item{transform}{a function that maps data stream points onto a 2-D plane for plotting.}

\item{\dots}{further arguments are passed on to \code{\link[graphics:plot.default]{graphics::plot.default()}} or \code{\link[graphics:pairs]{graphics::pairs()}}.
\pkg{graphics}.}
}
\description{
Method to plot the result of data stream data clustering. To plot \link{DSD} see \code{\link[=plot.DSD]{plot.DSD()}}.
}
\examples{
stream <- DSD_Gaussians(k = 3, d = 3, noise = 0.05)

## Example 1: Plot data
plot(stream)

## Example 2: Plot a clustering
dstream <- DSC_DStream(gridsize = 0.1)
update(dstream, stream, 500)
dstream
plot(dstream, stream)

## plot micro or macro-clusters only
plot(dstream, stream, type = "micro")
plot(dstream, stream, type = "macro")

## plot projected on the first two principal components
## and on dimensions 2 and 3
plot(dstream, stream, method = "pca")
plot(dstream, stream, dim = c(2, 3))

## D-Stream has a special implementation to show assignment areas
plot(dstream, stream, assignment = TRUE)

## Example 4: Use a custom transformation for plotting.
##     We fit PCA using 100 points and create a transformation
##     function to project the stream to the first two PCs.
pr <- princomp(get_points(stream, n = 100, info = FALSE))
trans <- function(x) predict(pr, x)[, 1:2 , drop = FALSE]

trans(get_points(stream, n = 3))

plot(dstream, stream, transform = trans)
}
\seealso{
Other DSC: 
\code{\link{DSC_Macro}()},
\code{\link{DSC_Micro}()},
\code{\link{DSC_R}()},
\code{\link{DSC_Static}()},
\code{\link{DSC_TwoStage}()},
\code{\link{DSC}()},
\code{\link{animate_cluster}()},
\code{\link{evaluate.DSC}},
\code{\link{get_assignment}()},
\code{\link{predict}()},
\code{\link{prune_clusters}()},
\code{\link{read_saveDSC}},
\code{\link{recluster}()}

Other plot: 
\code{\link{animate_cluster}()},
\code{\link{animate_data}()},
\code{\link{plot.DSD}()}
}
\author{
Michael Hahsler
}
\concept{DSC}
\concept{plot}
