/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.options.OptionHandler;
import moa.streams.InstanceStream;
import moa.streams.filters.StreamFilter;
import moa.tasks.TaskMonitor;
import weka.core.Instance;

public class FilteredStream
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to filter.", InstanceStream.class, "generators.RandomTreeGenerator");
    public ClassOption filtersOption = new ClassOption("filters", 'f', "Filters to apply.", StreamFilter.class, "AddNoiseFilter");
    protected InstanceStream filterChain;

    public String getPurposeString() {
        return "A stream that is filtered.";
    }

    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        monitor.setCurrentActivity("Materializing filter ...", -1.0);
        StreamFilter filters = (StreamFilter)this.getPreparedClassOption(this.filtersOption);
        if (monitor.taskShouldAbort()) {
            return;
        }
        if (filters instanceof OptionHandler) {
            monitor.setCurrentActivity("Preparing filter ...", -1.0);
            ((OptionHandler)((Object)filters)).prepareForUse(monitor, repository);
            if (monitor.taskShouldAbort()) {
                return;
            }
        }
        InstanceStream chain = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        filters.setInputStream(chain);
        this.filterChain = chain = filters;
    }

    public long estimatedRemainingInstances() {
        return this.filterChain.estimatedRemainingInstances();
    }

    public InstancesHeader getHeader() {
        return this.filterChain.getHeader();
    }

    public boolean hasMoreInstances() {
        return this.filterChain.hasMoreInstances();
    }

    public boolean isRestartable() {
        return this.filterChain.isRestartable();
    }

    public Instance nextInstance() {
        return this.filterChain.nextInstance();
    }

    public void restart() {
        this.filterChain.restart();
    }

    public void getDescription(StringBuilder sb, int indent) {
    }
}

