/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Random;
import moa.core.FastVector;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class ConceptDriftRealStream
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to add concept drift.", ExampleStream.class, "generators.RandomTreeGenerator");
    public ClassOption driftstreamOption = new ClassOption("driftstream", 'd', "Concept drift Stream.", ExampleStream.class, "generators.RandomTreeGenerator");
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Angle alpha of change grade.", 0.0, 0.0, 90.0);
    public IntOption positionOption = new IntOption("position", 'p', "Central position of concept drift change.", 0);
    public IntOption widthOption = new IntOption("width", 'w', "Width of concept drift change.", 1000);
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random noise.", 1);
    protected InstanceStream inputStream;
    protected InstanceStream driftStream;
    protected Random random;
    protected int numberInstanceStream;
    protected InstancesHeader streamHeader;
    protected Instance inputInstance;
    protected Instance driftInstance;

    @Override
    public String getPurposeString() {
        return "Adds Concept Drift to examples in a stream.";
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        int i;
        this.inputStream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        this.driftStream = (InstanceStream)this.getPreparedClassOption(this.driftstreamOption);
        this.random = new Random(this.randomSeedOption.getValue());
        this.numberInstanceStream = 0;
        if (this.alphaOption.getValue() != 0.0) {
            this.widthOption.setValue((int)(1.0 / Math.tan(this.alphaOption.getValue() * Math.PI / 180.0)));
        }
        InstancesHeader first = this.inputStream.getHeader();
        InstancesHeader second = this.driftStream.getHeader();
        FastVector<Attribute> newAttributes = new FastVector<Attribute>();
        for (i = 0; i < first.numAttributes() - 1; ++i) {
            newAttributes.addElement(first.attribute(i));
        }
        for (i = 0; i < second.numAttributes() - 1; ++i) {
            newAttributes.addElement(second.attribute(i));
        }
        Attribute classLabels = first.numClasses() < second.numClasses() ? second.classAttribute() : first.classAttribute();
        newAttributes.addElement(classLabels);
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), newAttributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public boolean isRestartable() {
        return this.inputStream.isRestartable() && this.driftStream.isRestartable();
    }

    @Override
    public InstanceExample nextInstance() {
        ++this.numberInstanceStream;
        double numclass = 0.0;
        double x = -4.0 * (double)(this.numberInstanceStream - this.positionOption.getValue()) / (double)this.widthOption.getValue();
        double probabilityDrift = 1.0 / (1.0 + Math.exp(x));
        if (this.random.nextDouble() > probabilityDrift) {
            if (!this.inputStream.hasMoreInstances()) {
                this.inputStream.restart();
            }
            this.inputInstance = (Instance)this.inputStream.nextInstance().getData();
            numclass = this.inputInstance.classValue();
        } else {
            if (!this.driftStream.hasMoreInstances()) {
                this.driftStream.restart();
            }
            this.driftInstance = (Instance)this.driftStream.nextInstance().getData();
            numclass = this.driftInstance.classValue();
        }
        int m = 0;
        double[] newVals = new double[this.inputInstance.numAttributes() + this.driftInstance.numAttributes() - 1];
        int j = 0;
        while (j < this.inputInstance.numAttributes() - 1) {
            newVals[m] = this.inputInstance.value(j);
            ++j;
            ++m;
        }
        j = 0;
        while (j < this.driftInstance.numAttributes() - 1) {
            newVals[m] = this.driftInstance.value(j);
            ++j;
            ++m;
        }
        newVals[m] = numclass;
        DenseInstance inst = new DenseInstance(1.0, newVals);
        inst.setDataset(this.getHeader());
        inst.setClassValue(numclass);
        return new InstanceExample(inst);
    }

    @Override
    public void restart() {
        this.inputStream.restart();
        this.driftStream.restart();
        this.numberInstanceStream = 0;
        this.inputInstance = (Instance)this.inputStream.nextInstance().getData();
        this.driftInstance = (Instance)this.driftStream.nextInstance().getData();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

