% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strptime.R
\name{strptime}
\alias{strptime}
\alias{strftime}
\title{Date-time Parsing and Formatting}
\usage{
strptime(x, format, tz = "", lenient = FALSE, locale = NULL)

strftime(
  x,
  format = "\%Y-\%m-\%dT\%H:\%M:\%S\%z",
  tz = "",
  usetz = FALSE,
  ...,
  locale = NULL
)
}
\arguments{
\item{x}{object to be converted: a character vector for \code{strptime}
and an object of class \code{POSIXct} for \code{strftime},
or objects coercible to}

\item{format}{character vector of date-time format specifiers,
see \code{\link[stringi]{stri_datetime_fstr}};
e.g., \code{"\%Y-\%m-\%d"} or \code{"datetime_full"};
the default conforms to the ISO 8601 guideline}

\item{tz}{\code{NULL} or \code{''} for the default time zone
(see \code{\link[stringi]{stri_timezone_get}})
or a single string with a timezone identifier,
see \code{\link[stringi]{stri_timezone_list}};
note that even when \code{x} is equipped with \code{tzone} attribute,
this datum is not used}

\item{lenient}{single logical value; should date/time parsing be lenient?}

\item{locale}{\code{NULL} or \code{''} for the default locale
(see \code{\link[stringi]{stri_locale_get}})
or a single string with a locale identifier,
see \code{\link[stringi]{stri_locale_list}}}

\item{usetz}{not used (with a warning if attempting to do so) [DEPRECATED]}

\item{...}{not used}
}
\value{
\code{strftime} returns a character vector (in UTF-8).

\code{strptime} returns an object of class \code{\link[base]{POSIXct}},
see also \link[base]{DateTimeClasses}.
If a string cannot be recognised as valid date/time specified
(as per the given format string), the corresponding output will be \code{NA}.
}
\description{
\code{strptime} parses strings representing date-time data
and converts it to a date-time object.
\code{strftime} formats a date-time object and outputs it as a
character vector.
}
\details{
Note that the ISO 8601 guideline suggests a year-month-day
date format and a 24-hour time format always indicating the effective
time zone, e.g., \code{2015-12-31T23:59:59+0100}. This is so as to avoid
ambiguity.
}
\section{Differences from Base R}{

Replacements for base \code{\link[base]{strptime}}
and \code{\link[base]{strftime}} implemented with
\code{\link[stringi]{stri_datetime_parse}} and
\code{\link[stringi]{stri_datetime_format}}.

\itemize{
\item formatting/parsing date-time in different locales and calendars
    is difficult and non-portable across platforms
    \bold{[fixed here -- using services provided by ICU]}
\item default format not conforming to ISO 8601, in particular not
    displaying the current time zone
    \bold{[fixed here]}
\item only the names attribute in \code{x} is propagated
    \bold{[fixed here]}
\item partial recycling with no warning
    \bold{[fixed here]}
\item \code{strptime} returns an object of class \code{POSIXlt},
    which is not the most convenient to work with, e.g., when
    including in data frames
    \bold{[fixed here]}
\item \code{strftime} does not honour the \code{tzone} attribute,
    which is used whilst displaying time (via \code{\link[base]{format}})
    \bold{[not fixed here]}
}
}

\examples{
stringx::strftime(Sys.time())  # default format - ISO 8601
f <- c("date_full", "\%Y-\%m-\%d", "date_relative_short", "datetime_full")
stringx::strftime(Sys.time(), f)  # current default locale
stringx::strftime(Sys.time(), f, locale="de_DE")
stringx::strftime(Sys.time(), "date_short", locale="en_IL@calendar=hebrew")
stringx::strptime("1970-01-01 00:00:00", "\%Y-\%m-\%d \%H:\%M:\%S", tz="GMT")
stringx::strptime("14 Nisan 5703", "date_short", locale="en_IL@calendar=hebrew")


}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{sprintf}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
