% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strtrim.R
\name{strtrim}
\alias{strtrim}
\title{Shorten Strings to Specified Width}
\usage{
strtrim(x, width)
}
\arguments{
\item{x}{character vector
whose elements are to be trimmed}

\item{width}{numeric vector giving the widths to which the corresponding
strings are to be trimmed}
}
\value{
Returns a character vector (in UTF-8).
Preserves object attributes
in a similar way as \link[base]{Arithmetic} operators.
}
\description{
Right-trims strings so that they do not exceed a given width
(as determined by \code{\link[stringi]{stri_width}}).
}
\details{
Both arguments are recycled if necessary.

Not to be confused with \code{\link{trimws}}.

Might be useful when displaying strings using a monospaced font.
}
\section{Differences from Base R}{

Replacement for base \code{\link[base]{strtrim}}
implemented with (special case of) \code{\link[stringi]{stri_sprintf}}.

\itemize{
\item both arguments are not recycled in an usual manner
    \bold{[fixed here]}
\item missing values are not allowed in \code{width}
    \bold{[fixed here]}
\item some emojis, combining characters and modifiers (e.g., skin tones)
   are not recognised properly \bold{[fixed here]}
\item attributes are only propagated from the 1st argument
    \bold{[fixed]}
}
}

\examples{
base::strtrim("aaaaa", 1:3)
stringx::strtrim("aaaaa", 1:3)
x <- c(
    "\U0001F4A9",
    "\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F",
    "\U0001F64D\U0001F3FB\U0000200D\U00002642",
    "\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F",
    "\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F"
)
print(x)
base::strtrim(x, 2)
stringx::strtrim(x, 2)

}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{sprintf}}, \code{\link{substr}},
    \code{\link{nchar}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
