% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strrep.R
\name{strrep}
\alias{strrep}
\alias{\%x*\%}
\title{Duplicate Strings}
\usage{
strrep(x, times)

e1 \%x*\% e2
}
\arguments{
\item{e1, x}{character vector (or an object coercible to)
whose elements are to be duplicated}

\item{e2, times}{numeric vector giving the number of times to repeat
the corresponding strings}
}
\value{
A character vector (in UTF-8).

\code{`\%x*\%`} and \code{strrep} preserve object attributes
in a similar way as other \link[base]{Arithmetic} operators.
}
\description{
Concatenate a number of copies of each string.
}
\details{
Both arguments are recycled if necessary.

The \code{`\%x*\%`} operator mimics a vectorised version of Python's
\code{`*`} for strings (\code{str.__mul__}).
}
\section{Differences from Base R}{

Replacement for base \code{\link[base]{strrep}}
implemented with \code{\link[stringi]{stri_dup}}.

\itemize{
\item partial recycling with no warning "longer object length is not
    a multiple of shorter object length" \bold{[fixed here]}
\item base \code{strrep} seems to preserve only the \code{names} attribute,
    and only if the input is of type character
    (whilst \code{paste} preserves nothing)
    \bold{[fixed]}
\item overloading \code{`*.character`} has no effect in R, because S3
    method dispatch is done internally with hard-coded support for
    character arguments. We could have replaced the generic \code{`*`}
    with the one that calls \code{\link[base]{UseMethod}}, but
    it feels like a too intrusive solution
    \bold{[fixed by introducing \code{`\%x+\%`} operator]}
}
}

\examples{
x <- structure(c(A="a", B=NA, C="c"), attrib1="value1")
x \%x*\% 3
x \%x*\% 1:3
"a" \%x*\% 1:3
stringx::strrep(x, 3)
base::strrep(x, 3)
y <- matrix(1:6, nrow=2, dimnames=list(c("A", "B"), NULL))
y \%x*\% 1:2
stringx::strrep(y, 1:2)
base::strrep(y, 1:2)

}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{paste}}, \code{\link{sprintf}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
