/*
 * Decompiled with CFR 0.152.
 */
package weka;

import java.beans.Beans;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import weka.associations.AbstractAssociator;
import weka.associations.Associator;
import weka.attributeSelection.ASEvaluation;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.Clusterer;
import weka.core.ClassDiscovery;
import weka.core.CommandlineRunnable;
import weka.core.WekaPackageManager;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.filters.Filter;

public class Run {
    public static void main(String[] args) {
        try {
            if (args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help")) {
                System.err.println("Usage:\n\tweka.Run [-no-scan] [-no-load] <scheme name [scheme options]>");
                System.exit(1);
            }
            boolean noScan = false;
            boolean noLoad = false;
            if (args[0].equals("-list-packages")) {
                WekaPackageManager.loadPackages(true, false);
                System.exit(0);
            } else if (args[0].equals("-no-load")) {
                noLoad = true;
                if (args.length > 1 && args[1].equals("-no-scan")) {
                    noScan = true;
                }
            } else if (args[0].equals("-no-scan")) {
                noScan = true;
                if (args.length > 1 && args[1].equals("-no-load")) {
                    noLoad = true;
                }
            }
            if (!noLoad) {
                WekaPackageManager.loadPackages(false, false);
            }
            int schemeIndex = 0;
            if (noLoad && noScan) {
                schemeIndex = 2;
            } else if (noLoad || noScan) {
                schemeIndex = 1;
            }
            String schemeToRun = null;
            String[] options = null;
            if (schemeIndex >= args.length) {
                System.err.println("No scheme name given.");
                System.exit(1);
            }
            schemeToRun = args[schemeIndex];
            options = new String[args.length - schemeIndex - 1];
            if (options.length > 0) {
                System.arraycopy(args, schemeIndex + 1, options, 0, options.length);
            }
            if (!noScan) {
                ClassDiscovery.clearClassCache();
                ArrayList<String> matches = ClassDiscovery.find(schemeToRun);
                ArrayList<String> prunedMatches = new ArrayList<String>();
                for (int i = 0; i < matches.size(); ++i) {
                    try {
                        Object scheme = Beans.instantiate(new Run().getClass().getClassLoader(), matches.get(i));
                        if (!(scheme instanceof Classifier) && !(scheme instanceof Clusterer) && !(scheme instanceof Associator) && !(scheme instanceof ASEvaluation) && !(scheme instanceof Filter) && !(scheme instanceof AbstractFileLoader) && !(scheme instanceof AbstractFileSaver) && !(scheme instanceof CommandlineRunnable)) continue;
                        prunedMatches.add(matches.get(i));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (prunedMatches.size() == 0) {
                    System.err.println("Can't find scheme " + schemeToRun + ", or it is not runnable.");
                    System.exit(1);
                } else if (prunedMatches.size() > 1) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    boolean done = false;
                    while (!done) {
                        System.out.println("Select a scheme to run, or <return> to exit:");
                        for (int i = 0; i < prunedMatches.size(); ++i) {
                            System.out.println("\t" + (i + 1) + ") " + (String)prunedMatches.get(i));
                        }
                        System.out.print("\nEnter a number > ");
                        String choice = null;
                        int schemeNumber = 0;
                        try {
                            choice = br.readLine();
                            if (choice.equals("")) {
                                System.exit(0);
                                continue;
                            }
                            schemeNumber = Integer.parseInt(choice);
                            if (--schemeNumber < 0 || schemeNumber >= prunedMatches.size()) continue;
                            schemeToRun = (String)prunedMatches.get(schemeNumber);
                            done = true;
                        }
                        catch (IOException ex) {}
                    }
                } else {
                    schemeToRun = (String)prunedMatches.get(0);
                }
            }
            Object scheme = null;
            try {
                scheme = Beans.instantiate(new Run().getClass().getClassLoader(), schemeToRun);
            }
            catch (Exception ex) {
                System.err.println(schemeToRun + " is not runnable!");
                System.exit(1);
            }
            ArrayList<SchemeType> types = new ArrayList<SchemeType>();
            if (scheme instanceof Classifier) {
                types.add(SchemeType.CLASSIFIER);
            }
            if (scheme instanceof Clusterer) {
                types.add(SchemeType.CLUSTERER);
            }
            if (scheme instanceof Associator) {
                types.add(SchemeType.ASSOCIATOR);
            }
            if (scheme instanceof ASEvaluation) {
                types.add(SchemeType.ATTRIBUTE_SELECTION);
            }
            if (scheme instanceof Filter) {
                types.add(SchemeType.FILTER);
            }
            if (scheme instanceof AbstractFileLoader) {
                types.add(SchemeType.LOADER);
            }
            if (scheme instanceof AbstractFileSaver) {
                types.add(SchemeType.SAVER);
            }
            if (scheme instanceof CommandlineRunnable) {
                types.add(SchemeType.COMMANDLINE);
            }
            SchemeType selectedType = null;
            if (types.size() == 0) {
                System.err.println("" + schemeToRun + " is not runnable!");
                System.exit(1);
            }
            if (types.size() == 1) {
                selectedType = (SchemeType)((Object)types.get(0));
            } else {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                boolean done = false;
                while (!done) {
                    System.out.println("" + schemeToRun + " can be executed as any of the following:");
                    for (int i = 0; i < types.size(); ++i) {
                        System.out.println("\t" + (i + 1) + ") " + types.get(i));
                    }
                    System.out.print("\nEnter a number > ");
                    String choice = null;
                    int typeNumber = 0;
                    try {
                        choice = br.readLine();
                        if (choice.equals("")) {
                            System.exit(0);
                            continue;
                        }
                        typeNumber = Integer.parseInt(choice);
                        if (--typeNumber < 0 || typeNumber >= types.size()) continue;
                        selectedType = (SchemeType)((Object)types.get(typeNumber));
                        done = true;
                    }
                    catch (IOException ex) {}
                }
            }
            if (selectedType == SchemeType.CLASSIFIER) {
                AbstractClassifier.runClassifier((Classifier)scheme, options);
            } else if (selectedType == SchemeType.CLUSTERER) {
                AbstractClusterer.runClusterer((Clusterer)scheme, options);
            } else if (selectedType == SchemeType.ATTRIBUTE_SELECTION) {
                ASEvaluation.runEvaluator((ASEvaluation)scheme, options);
            } else if (selectedType == SchemeType.ASSOCIATOR) {
                AbstractAssociator.runAssociator((Associator)scheme, options);
            } else if (selectedType == SchemeType.FILTER) {
                Filter.runFilter((Filter)scheme, options);
            } else if (selectedType == SchemeType.LOADER) {
                AbstractFileLoader.runFileLoader((AbstractFileLoader)scheme, options);
            } else if (selectedType == SchemeType.SAVER) {
                AbstractFileSaver.runFileSaver((AbstractFileSaver)scheme, options);
            } else if (selectedType == SchemeType.COMMANDLINE) {
                ((CommandlineRunnable)scheme).run(scheme, options);
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf("General options") == -1 || e.getMessage() == null) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
    }

    public static enum SchemeType {
        CLASSIFIER("classifier"),
        CLUSTERER("clusterer"),
        ASSOCIATOR("association rules"),
        ATTRIBUTE_SELECTION("attribute selection"),
        FILTER("filter"),
        LOADER("loader"),
        SAVER("saver"),
        COMMANDLINE("general commandline runnable");

        private final String m_stringVal;

        private SchemeType(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

