% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/proclus.R
\name{ProClus}
\alias{ProClus}
\title{The ProClus Algorithm for Projected Clustering}
\usage{
ProClus(data, k = 4, d = 3)
}
\arguments{
\item{data}{A Matrix of input data.}

\item{k}{Number of Clusters to be found.}

\item{d}{Average number of dimensions in which the clusters reside}
}
\description{
The ProClus algorithm works in a manner similar to K-Medoids.
 Initially, a set of medoids of a size that is proportional to k is chosen.
 Then medoids that are likely to be outliers or are part of a cluster that is
 better represented by another medoid are removed until k medoids are left.
 Clusters are then assumed to be around these medoids.
}
\examples{
data("subspace_dataset")
ProClus(subspace_dataset,k=12,d=2.5)
}
\references{
C. C. Aggarwal and C. Procopiuc \emph{Fast Algorithms for
 Projected Clustering}. In Proc. ACM SIGMOD 1999.
}
\seealso{
Other subspace.clustering.algorithms: \code{\link{CLIQUE}};
  \code{\link{FIRES}}; \code{\link{P3C}};
  \code{\link{SubClu}}
}

