% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsPlotting_advanced.R
\name{superbPlot.raincloud}
\alias{superbPlot.raincloud}
\title{superbPlot 'raincloud' layout}
\usage{
superbPlot.raincloud(
  summarydata,
  xfactor,
  groupingfactor,
  addfactors,
  rawdata = NULL,
  violinParams = list(),
  jitterParams = list(),
  pointParams = list(),
  errorbarParams = list(),
  facetParams = list(),
  xAsFactor = TRUE
)
}
\arguments{
\item{summarydata}{a data.frame with columns "center", "lowerwidth" and "upperwidth" for each level of the factors;}

\item{xfactor}{a string with the name of the column where the factor going on the horizontal axis is given;}

\item{groupingfactor}{a string with the name of the column for which the data will be grouped on the plot;}

\item{addfactors}{a string with up to two additional factors to make the rows and columns panels, in the form "fact1 ~ fact2";}

\item{rawdata}{always contains "DV" for each participants and each level of the factors}

\item{violinParams}{(optional) list of graphic directives that are sent to the geom_violin layer}

\item{jitterParams}{(optional) list of graphic directives that are sent to the geom_jitter layer}

\item{pointParams}{(optional) list of graphic directives that are sent to the geom_point layer}

\item{errorbarParams}{(optional) list of graphic directives that are sent to the geom_superberrorbar layer}

\item{facetParams}{(optional) list of graphic directives that are sent to the facet_grid layer}

\item{xAsFactor}{(optional) Boolean to indicate if the factor on the horizontal should continuous or discrete (default is discrete)}
}
\value{
a ggplot object
}
\description{
The raincloud layout display jittered dots as well as a "cloud" (half of a violin) above them.
See Allen, Poggiali, Whitaker, Marshall, & Kievit (2018)
The functions has these parameters:
}
\examples{
# This will make a plot with raincloud; they are better seen rotated: +coord_flip()
superbPlot(ToothGrowth, 
   BSFactors = c("dose","supp"), variables = "len",
   plotStyle="raincloud" 
)

# if you extract the data with superbData, you can 
# run this layout directly
#processedData <- superbData(ToothGrowth, 
#   BSFactors = c("dose","supp"), variables = "len"
#)
#
#superbPlot.raincloud(processedData$summaryStatistic,
#   "dose",
#   "supp",
#   ".~.",
#   processedData$rawData)

}
\references{
\insertAllCited{}
}
