% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superbPlot.R
\name{superbPlot}
\alias{superbPlot}
\title{summary plot of any statistics with adjusted error bars.}
\usage{
superbPlot(
  data,
  BSFactors = NULL,
  WSFactors = NULL,
  WSDesign = "fullfactorial",
  factorOrder = NULL,
  variables,
  statistic = "mean",
  errorbar = "CI",
  gamma = 0.95,
  adjustments = list(purpose = "single", popSize = Inf, decorrelation = "none",
    samplingDesign = "SRS"),
  showPlot = TRUE,
  plotStyle = "bar",
  preprocessfct = NULL,
  postprocessfct = NULL,
  clusterColumn = "",
  ...
)
}
\arguments{
\item{data}{Dataframe in wide format}

\item{BSFactors}{The name of the columns containing the between-subject factor(s)}

\item{WSFactors}{The name of the within-subject factor(s)}

\item{WSDesign}{the within-subject design if not a full factorial design (default "fullfactorial")}

\item{factorOrder}{Order of factors as shown in the graph (in that order: x axis,
groups, horizontal panels, vertical panels)}

\item{variables}{The dependent variable(s) as strings}

\item{statistic}{The summary statistic function to use as a string}

\item{errorbar}{The function that computes the error bar. Should be "CI" or "SE" or
any function name if you defined a custom function. Default to "CI"}

\item{gamma}{The coverage factor; necessary when \code{errorbar == "CI"}. Default is 0.95.}

\item{adjustments}{List of adjustments as described below.
Default is \code{adjustments = list(purpose = "single", popSize = Inf, decorrelation = "none", samplingDesign = "SRS")}}

\item{showPlot}{Defaults to TRUE. Set to FALSE if you want the output to be the summary
statistics and intervals.}

\item{plotStyle}{The type of object to plot on the graph. See full list below.
Defaults to "bar".}

\item{preprocessfct}{is a transform (or vector of) to be performed first on data matrix of each group}

\item{postprocessfct}{is a transform (or vector of)}

\item{clusterColumn}{used in conjunction with samplingDesign = "CRS", indicates which column
contains the cluster membership}

\item{...}{In addition to the parameters above, superbPlot also accept a number of
optional arguments that will be transmitted to the plotting function, such as
pointParams (a list of g`lot2 parameters to input inside geoms; see ?geom_bar2) and
errorbarParams (a list of ggplot2 parameters for geom_errorbar; see ?geom_errorbar)}
}
\value{
a plot with the correct error bars or a table of those summary statistics.
The plot is a ggplot2 object with can be modified with additional declarations.
}
\description{
The function \code{superbPlot()} plots standard error or confidence interval for various
descriptive statistics under various designs, sampling schemes, population size and purposes,
according to the \code{suberb} framework. See \insertCite{cgh21}{superb} for more.
Note that this function has been superseded by \code{superb()}.
}
\details{
The possible adjustements are the following
\itemize{
\item popsize: Size of the population under study. Defaults to Inf
\item purpose: The purpose of the comparisons. Defaults to "single".
Can be "single", "difference", or "tryon".
\item decorrelation: Decorrelation method for repeated measure designs.
Chooses among the methods "CM", "LM", "CA", "UA", "LDr" (with r an integer) or "none". Defaults to
"none". "CA" is correlation-adjusted \insertCite{c19}{superb};
"UA" is based on the unitary Alpha method (derived from the Cronbach alpha;
see \insertCite{lc22}{superb}).
"LDr" is local decorrelation (useful for long time series with autoregressive
correlation structures; see \insertCite{cppf24}{superb});
.
\item samplingDesign: Sampling method to obtain the sample. implemented
sampling is "SRS" (Simple Randomize Sampling) and "CRS" (Cluster-Randomized Sampling).
}

As of version 0.97.15, the layouts for plots are the following:
\itemize{
\item "bar" Shows the summary statistics with bars and error bars;
\item "line" Shows the summary statistics with lines connecting the conditions over the first factor;
\item "point" Shows the summary statistics with isolated points
\item "pointjitter" Shows the summary statistics along with jittered points depicting the raw data;
\item "pointjitterviolin" Also adds violin plots to the previous layout
\item "pointindividualline" Connects the raw data with line along the first factor (which should be a repeated-measure factor)
\item "raincloud" Illustrates the distribution with a cloud (half_violin_plot) and jittered dots next to it. Looks better when coordinates are flipped \code{+coord_flip()}.
\item "corset" Illustrates two repeated-measures with individual lines and clouds
\item "boxplot" Illustrates the limits, the quartiles and the median using a box
}

but refer to \code{superb()} for a documentation that will be kept up do date.
}
\examples{
######################################################################

# Basic example using a built-in dataframe as data. 
# By default, the mean is computed and the error bar are 95\% confidence intervals
superbPlot(ToothGrowth, BSFactors = c("dose", "supp"), 
  variables = "len") 

# Note that function superb() does the same with formula:
superb( len ~ dose + supp, ToothGrowth )

# Example changing the summary statistics to the median and
# the error bar to 80\% confidence intervals
superbPlot(ToothGrowth, BSFactors = c("dose", "supp"), 
  variables = "len", statistic = "median", errorbar = "CI", gamma = .80) 

# Example introducing adjustments for pairwise comparisons 
# and assuming that the whole population is limited to 200 persons
superbPlot(ToothGrowth, BSFactors = c("dose", "supp"), 
  variables = "len",  
  adjustments = list( purpose = "difference", popSize = 200) )

# This example adds ggplot directives to the plot produced
library(ggplot2)
superbPlot(ToothGrowth, BSFactors = c("dose", "supp"), 
  variables = "len") + 
xlab("Dose") + ylab("Tooth Growth") +
theme_bw()

######################################################################

# The following examples are based on repeated measures
library(gridExtra)
options(superb.feedback = 'none') # shut down 'warnings' and 'design' interpretation messages

# A simple example: The sleep data
# The sleep data are paired data showing the additional time of sleep with 
# the soporific drugn #1 (("group = 1") and with the soporific drug #2 ("group = 2"). 
# There is 10 participants with two measurements.

# sleep is available in long format so we transform it to the in wide format:
sleep2 <- reshape(sleep, direction = "wide", idvar = "ID", timevar = "group")
sleep2

# Makes the plots first without decorrelation:
superbPlot(sleep2, 
  WSFactors = "Times(2)", 
  variables = c("extra.1", "extra.2")
)
# As seen the error bar are very long. Lets take into consideration correlation...
# ...  with decorrelation (technique Correlation-adjusted CA):
superbPlot(sleep2, 
  WSFactors = "Times(2)", 
  variables = c("extra.1", "extra.2"), 
  # only difference:
  adjustments = list(purpose = "difference", decorrelation = "CA")
)
# The error bars shortened as the correlation is substantial (r = .795).


######################################################################

# Another example: The Orange data
data(Orange)
# Use the Orange example, but let's define shorter column names...
names(Orange) <- c("Tree","age","circ")
# ... and turn the data into a wide format using superbToWide:
Orange.wide <- superbToWide(Orange, id = "Tree", WSFactors = "age", variable = "circ") 

# This example contains 5 trees whose diameter (in mm) has been measured at various age (in days):
Orange.wide

# Makes the plots first without decorrelation:
p1 <- superbPlot( Orange.wide, WSFactors = "age(7)",
  variables = c("circ.118","circ.484","circ.664","circ.1004","circ.1231","circ.1372","circ.1582"),
  adjustments = list(purpose = "difference", decorrelation = "none")
) + 
  xlab("Age level") + ylab("Trunk diameter (mm)") +
  coord_cartesian( ylim = c(0,250) ) + labs(title="''Standalone'' confidence intervals")
# ... and then with decorrelation (technique Correlation-adjusted CA):
p2 <- superbPlot( Orange.wide, WSFactors = "age(7)",
  variables = c("circ.118","circ.484","circ.664","circ.1004","circ.1231","circ.1372","circ.1582"),
  adjustments = list(purpose = "difference", decorrelation = "CA")
) + 
  xlab("Age level") + ylab("Trunk diameter (mm)") +
  coord_cartesian( ylim = c(0,250) ) + labs(title="Decorrelated confidence intervals")

# You can present both plots side-by-side
grid.arrange(p1, p2, ncol=2)

######################################################################


}
\references{
\insertAllCited{}
}
