% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TfidfVectorizer.R
\docType{data}
\name{TfIdfVectorizer}
\alias{TfIdfVectorizer}
\title{TfIDF(Term Frequency Inverse Document Frequency) Vectorizer}
\format{\code{\link{R6Class}} object.}
\usage{
TfIdfVectorizer
}
\description{
Provides an easy way to create tf-idf matrix of features in R. It consists of fit, transform
              methods (similar to sklearn) to generate tf-idf features.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
tf_object = TfIdfVectorizer$new(max_df=1, min_df=1, max_features=1, smooth_idf=TRUE)
tf_object$fit(sentences)
tf_matrix = tf_object$transform(sentences)
tf_matrix = tf_object$fit_transform(sentences) ## alternate
}
}

\section{Methods}{

\describe{
    \item{\code{$new()}}{Initialise the instance of the vectorizer}
    \item{\code{$fit()}}{creates a memory of count vectorizers but doesn't return anything}
    \item{\code{$transform()}}{based on encodings learned in \code{fit} method, returns the tf-idf matrix }
    \item{\code{$fit_transform()}}{returns tf-idf matrix}
}
}

\examples{
df <- data.frame(sents = c('i am alone in dark.',
                           'mother_mary a lot',
                           'alone in the dark?',
                           'many mothers in the lot....'))
tf <- TfIdfVectorizer$new(smooth_idf = TRUE, min_df = 0.3)
tf_features <- tf$fit_transform(df$sents)
}
\keyword{datasets}
