% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPMFPlot.R
\name{survPMFPlot}
\alias{survPMFPlot}
\title{Plots marginal and joint probability mass functions.}
\usage{
survPMFPlot(bivarSurf, gridWidthX, gridWidthY,
scaleGapX, scaleGapY, scaleHistX, scaleHistY,
XAxisLabel, YAxisLabel, lineXAxisLabel, lineYAxisLabel,
timeLabelScale, axisLabelScale,
labelSkipX, labelSkipY, roundX, roundY,
plotLabel, linePlotLabel)
}
\arguments{
\item{bivarSurf}{A matrix containing marginal and joint survival probabilities.  The first column is the marginal survival probability corresponding to variable \code{X}. The first row is the marginal survival probability corresponding to variable \code{Y}. The rest of the matrix contains the joint survival probabilities. The row names of \code{bivarSurf} are ordered \code{X} values. The column names of \code{bivarSurf} are ordered \code{Y} values. Element \code{bivarSurf[1,1]} equals 1. Its row and column name is \code{'0'} (see the documentation for the return value \code{DabrowskaEst} in function \code{survDabrowska})}

\item{gridWidthX}{Grid size on \code{X}-axis.}

\item{gridWidthY}{Grid size on \code{Y}-axis.}

\item{scaleGapX}{The proportion by which the gap between the marginal and joint histograms along the X-axis is increased (if >1) or decreased (if >0 and <1).}

\item{scaleGapY}{The proportion by which the gap between the marginal and joint histograms along the Y-axis is increased (if >1) or decreased (if >0 and <1).}

\item{scaleHistX}{The proportion by which to increase (if >1) or decrease (if >0 and <1) the height of the marginal histogram along the X-axis.}

\item{scaleHistY}{The proportion by which to increase (if >1) or decrease (if >0 and <1) the height of the marginal histogram along the Y-axis.}

\item{XAxisLabel}{\code{X}-axis label.}

\item{YAxisLabel}{\code{Y}-axis label.}

\item{lineXAxisLabel}{Line where to place the \code{X}-axis label (used by function \code{mtext}).}

\item{lineYAxisLabel}{Line where to place the \code{Y}-axis label (used by function \code{mtext}).}

\item{timeLabelScale}{The proportion by which the axis labels is increased (if >1) or decreased (if >0 and <1).}

\item{axisLabelScale}{The proportion by which the time grid labels are increased (if >1) or decreased (if >0 and <1).}

\item{labelSkipX}{If the time grid looks too busy, not all \code{X}-label time grid labels have to be printed. For example, if \code{labelSkipX = 1} then every other label is printed starting from the first (time 0). If \code{labelSkipX = 2} then the 1st, 4rd, 7th, 10th, ... and so on, labels are printed. The default is \code{0}, which means that all time grid labels are printed.}

\item{labelSkipY}{If the time grid looks too busy, not all \code{Y}-label time grid labels have to be printed. For example, if \code{labelSkipY = 1} then every other label is printed starting from the first (time 0). If \code{labelSkipX = 2} then the 1st, 4rd, 7th, 10th, ... and so on, labels are printed. The default is \code{0}, which means that all time grid labels are printed.}

\item{roundX}{Number of decimal places in time grid labels for \code{X}-label.}

\item{roundY}{Number of decimal places in time grid labels for \code{Y}-label.}

\item{plotLabel}{Plot label.}

\item{linePlotLabel}{Line where to place the plot label (used by function \code{mtext}).}
}
\value{
None
}
\description{
Plots marginal and joint probability mass functions for bivariate survival data.
}
\details{
Plots marginal and joint probability mass functions (PMFs) from marginal and joint survival probabilities. The probability mass gets aggregated into cells according to the user-specified arguments \code{gridWidthX} and \code{gridWidthY}. After this aggregation, the negative values (if any) are set to zero. Marginal probability mass functions are displayed as histograms. Joint probability mass function is displayed as a matrix with darker cells indicating larger probability mass aggregated in this cell. Zero mass is denoted with a very faint gray shade. Because the shading is relative, with greater range of probability mass more gray shades are observed. A future version of the function will allow users to choose their own shading/color function.
}
\examples{
X = c(0.5, 0.61, 0.6, 0.8, 0.78, 0.7, 0.9)
Y = c(0.44, 0.15, 0.77, 0.88, 0.22, 0.99, .33)
deltaX = c(1, 0, 1, 1, 0, 1, 0)
deltaY = c(1, 0, 1, 0, 1, 1, 1)

dabrSurf = survDabrowska(X, Y, deltaX, deltaY)$DabrowskaEst

grid = 0.1
survPMFPlot(bivarSurf = dabrSurf, gridWidthX = grid, gridWidthY = grid,
            scaleGapX = 1, scaleGapY = 1,
            XAxisLabel = "X", YAxisLabel = "Y", timeLabelScale = 1,
            axisLabelScale = 1,
            labelSkipX = 0, labelSkipY = 0, roundX = 2, roundY = 2,
            plotLabel = "Bivariate PMF")

}
\references{
Eden, S.K., Li, C., Shepherd B.E. (2021). Non-parametric Estimation of Spearman's Rank Correlation with Bivariate Survival Data. Biometrics (under revision).
}
\author{
Svetlana K Eden, \email{svetlanaeden@gmail.com}
}
\keyword{PMF}
\keyword{bivariate}
\keyword{plot}
