% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/questions.R
\name{question_text}
\alias{question_text}
\title{Returns question text.}
\usage{
question_text(x, Q)
}
\arguments{
\item{x}{A surveydata object}

\item{Q}{The question id, e.g. "Q4". If not supplied, returns the text for all questions.}
}
\value{
character vector
}
\description{
Given a question id, e.g. "Q4", returns question text for this question. Note that this returns. The functions \code{\link[=question_text_unique]{question_text_unique()}} and \code{\link[=question_text_common]{question_text_common()}} returns the unique and common components of the question text.
}
\examples{
# Basic operations on a surveydata object, illustrated with the example dataset membersurvey

class(membersurvey)

questions(membersurvey)

which.q(membersurvey, "Q1")
which.q(membersurvey, "Q3")
which.q(membersurvey, c("Q1", "Q3"))

question_text(membersurvey, "Q3")
question_text_unique(membersurvey, "Q3")
question_text_common(membersurvey, "Q3")

# Extracting columns from a surveydata object

head(membersurvey[, "Q1"])
head(membersurvey["Q1"])
head(membersurvey[, "Q3"])
head(membersurvey[, c("Q1", "Q3")])

# Note that the result is always a surveydata object, even if only one column is extracted

head(membersurvey[, "id"])
str(membersurvey[, "id"])

}
\seealso{
Other Question functions: \code{\link{question_text_common}},
  \code{\link{question_text_unique}},
  \code{\link{questions}},
  \code{\link{split_common_unique}}, \code{\link{which.q}}
}
\concept{Question functions}
\keyword{Questions}
