% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfit.R
\name{survfit.survstan}
\alias{survfit.survstan}
\title{survfit method for survstan models}
\usage{
\method{survfit}{survstan}(formula, newdata, ...)
}
\arguments{
\item{formula}{an object of the class survstan}

\item{newdata}{a data frame containing the set of explanatory variables.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list containing the estimated survival probabilities.
}
\description{
Computes the predicted survivor function for a phpe model.
}
\examples{
\donttest{
library(survstan)
library(ggplot2)
data(ipass)
ipass$arm <- as.factor(ipass$arm)
fit <- ypreg(Surv(time, status)~arm, data=ipass, baseline = "weibull")
summary(fit)
newdata <- data.frame(arm=as.factor(0:1))
surv <- survfit(fit, newdata)
ggplot(surv, aes(x=time, y=surv, color = arm)) +
  geom_line()
}

}
