% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_open.tcltkGUI.R
\name{dlg_open.tcltkGUI}
\alias{dlg_open.tcltkGUI}
\title{A Tcl/Tk version of the {svDialogs} file open dialog box}
\usage{
\method{dlg_open}{tcltkGUI}(
  default = "",
  title = if (multiple) "Select files" else "Select file",
  multiple = FALSE,
  filters = dlg_filters["All", ],
  ...,
  gui = .GUI
)
}
\arguments{
\item{default}{The default file to start with (use \verb{/dir/*} or \verb{/dir/*.*} to
start in a given directory).}

\item{title}{A title to display on top of the dialog box.}

\item{multiple}{Is a multiple selection of files allowed?}

\item{filters}{A specification of file filters as a \code{nx2} matrix, or a
character string with even number of items. First items is the label, second
one is the filter. See \code{dlg_filters} for examples. This is currently ignored
on MacOS and RStudio, since such kind of filter is defined differently there.}

\item{...}{Not used yet.}

\item{gui}{The 'gui' object concerned by this dialog box.}
}
\value{
The path to the file to open.
}
\description{
A Tcl/Tk version of the {svDialogs} file open dialog box
}
\examples{
library(svDialogstcltk) # Tcl/Tk dialog boxes are now used by default
\dontrun{
# Choose one R file
dlg_open(title = "Select one R file", filters = dlg_filters[c("R", "All"), ])$res
# Choose several files
dlg_open(multiple = TRUE)$res
}
}
\seealso{
\code{\link[svDialogs:dlg_open]{svDialogs::dlg_open()}}
}
\concept{Modal dialog box}
\keyword{misc}
