% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swarm_space.R
\name{expand_pca_swarm_space}
\alias{expand_pca_swarm_space}
\title{Expand Existing Swarm Space (PCA)}
\usage{
expand_pca_swarm_space(metrics_data, pca_space, event_dur_limit = NA)
}
\arguments{
\item{metrics_data}{A dataframe with the new metrics data to add in swarm space.}

\item{pca_space}{The PCA object to predict from, the output of the
\code{stats::prcomp} function or the pca element of the list output
of the \code{swarm_space} function.}

\item{event_dur_limit}{Numeric, capturing an event duration value in seconds.
Used to filter out events that are shorter that this value.
Default = NA, no filtering is applied.}
}
\value{
A dataframe with the x and y coordinates in the input swarm space
per event of the new species.
}
\description{
This function predicts the positions of new event data in an
existing PCA space using the \code{stats::predict} function.
}
\examples{

data(multi_species_metrics)
data(multi_species_pca)
ss <- expand_pca_swarm_space(multi_species_metrics,
multi_species_pca)

}
\seealso{
\code{\link{swarm_space}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
