% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_nationalvotes.R
\name{plot_nationalvotes}
\alias{plot_nationalvotes}
\title{Plot National Votes}
\usage{
plot_nationalvotes(
  votedate = NULL,
  vote_id = NULL,
  geolevel = "municipality",
  measure = "result",
  standardize = T,
  lakes = T,
  language = "DE",
  theme = "srf"
)
}
\arguments{
\item{votedate}{date of the ballot. Default: most recent ballot available.}

\item{vote_id}{id of the vote. Default: first id mentioned in the data set.}

\item{geolevel}{geographical level. Options: "canton", "district", "municipality" or "zh_counting_districts".}

\item{measure}{measure to color the administrative units. Options: "result" for the yes vote share or "turnout"
for the voter turnout of a given vote.}

\item{standardize}{if \code{TRUE}, the scale of the measure ranges from 0 to 100 percent. Recommended for comparisons 
between votes.}

\item{lakes}{if \code{TRUE}, the largest Swiss lakes are shown in color on the map.}

\item{language}{defines the language. Options: "DE" for German, "FR" for French, "IT" for Italian or "RM" for Romansh.}

\item{theme}{defines basic appearance of the map. Five options are available: "srf" for a theme inspired by the
plots of Swiss Radio and Television, and "A" to "E" for the viridis color scales magma, inferno, plasma, viridis and cividis.}
}
\value{
a ggplot object
}
\description{
\code{plot_nationalvotes} plots the results of national votes in a choropleth map using ggplot2.
}
\examples{

# Plot the most recent national vote
plot_nationalvotes()

# Plot a specific national vote at cantonal level
plot_nationalvotes(
    votedate = "2014-02-09",
    vote_id = 5800,
    geolevel = "canton"
    )

}
