% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{boot}
\alias{boot}
\title{Bootstrap covariance matrix for least squares estimates of linear regression}
\usage{
boot(model, iter = 100)
}
\arguments{
\item{model}{object of class \code{lm}.}

\item{iter}{positive integer representing the number of bootstrap iterations.}
}
\value{
This function returns a bootstrapped covariance matrix of the
least squares estimator.
}
\description{
This function calculates bootstrapped covariance matrix
for least squares estimates of linear regression. The estimates should be
obtained via \code{lm} function.
}
\details{
Calculations may take long time for high \code{iter} value.
}
\examples{
set.seed(123)
# Generate data according to linear regression
n <- 20
eps <- rnorm(n)
x <- runif(n)
y <- x + eps
# Estimate the model
model <- lm(y ~ x)
# Calculate bootstrap covariance matrix
boot(model, iter = 50)
}
