% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_counts.r
\name{doc_counts}
\alias{doc_counts}
\title{doc_counts}
\usage{
doc_counts(s, nthreads = sylcount.nthreads())
}
\arguments{
\item{s}{A character vector (vector of strings).}

\item{nthreads}{Number of threads to use. By default it will use the total number of
cores + hyperthreads.}
}
\value{
A dataframe containing:
\tabular{ll}{
  \code{chars}     \tab the total numberof characters \cr
  \code{wordchars} \tab the number of alphanumeric characters \cr
  \code{words}     \tab text tokens that are probably English language words \cr
  \code{nonwords}  \tab text tokens that are probably not English language words \cr
  \code{sents}     \tab the number of sentences recognized in the text \cr
  \code{sylls}     \tab the total number of syllables (ignores all non-words) \cr
  \code{polys}     \tab the total number of "polysyllables", or words with 3+ syllables \cr
}
}
\description{
Computes some basic document counts (see the 'Value' section below for
details).

The function is vectorized by document, and scores are computed in parallel
via OpenMP.  You can control the number of threads used with the
\code{nthreads} parameter.
}
\details{
The function is essentially just \code{readability()} without the readability
scores.
}
\examples{
library(sylcount)
a <- "I am the very model of a modern major general."
b <- "I have information vegetable, animal, and mineral."

doc_counts(c(a, b), nthreads=1)

}
\seealso{
\code{\link{readability}}
}
