% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symengine.R
\docType{package}
\name{symengine}
\alias{symengine}
\title{symengine: R interface to SymEngine C++ library for symbolic computation}
\description{
\code{symengine} is a R package for symbolic computation.
}
\details{
\href{https://github.com/symengine/}{SymEngine library} is a standalone fast symbolic
manipulation library written in C++. It allows computation over mathematical expressions
in a way which is similar to the traditional manual computations of mathematicians and
scientists. The R interface of the library tries to provide a user-friendly way to do
symbolic computation in R and can be integrated into other packages to help solve related
tasks. The design of the package is somehow similar to the \href{https://www.sympy.org}{SymPy}
package in Python. Unlike some other computer algebra systems, it does not invent its own
language or domain specific language but uses R language to manipulate the symbolic
expressions.

\code{symengine} uses the S4 dispatch system extensively to differentiate between calculation
over normal R objects and symengine objects. For example, the semantics of \code{sin} in
\verb{expr <- Symbol("x"); sin(expr)} is different from the \code{sin} used over normal R numbers.
}
\section{Basic class}{

\code{Basic} is simply a S4 class holding a pointer representing a symbolic expression
in symengine. \code{Basic} objects have the same S4 class but can have different
C-level representations which can be accessed via \code{\link[=get_type]{get_type()}}.
For example, \code{Basic(~ 1/2)} will have "Rational" type and \code{Basic(1/2)} will have
"RealDouble" type.

A \code{Basic} object will also have a list of associated sub-components
which can be accessed via \code{\link[=get_args]{get_args()}}. For example, \code{(expr <- S("x") * 3L * S("a"))}
will have type "Mul", and \code{as.list(get_args(expr))} will show the three factors of
the multiplication.

A \code{Basic} object can be constructed via \code{\link[=Basic]{Basic()}}, \code{\link[=S]{S()}}, \code{\link[=Symbol]{Symbol()}}, \code{\link[=Constant]{Constant()}} or
\code{\link[=Real]{Real()}}.
}

\section{VecBasic and DenseMatrix class}{

VecBasic and DenseMatrix are S4 classes representing a symbolic vector or matrix.
They can be constructed with \code{\link[=Vector]{Vector()}}, \code{\link[=V]{V()}}, \code{\link[=Matrix]{Matrix()}}, \code{c()}, \code{rbind()}
or \code{cbind()}. For example the following code will construct a 2x3 matrix.

\if{html}{\out{<div class="sourceCode">}}\preformatted{vec <- Vector("a", "b")
cbind(vec, vec^2L, c(S("c"), S("d")))
}\if{html}{\out{</div>}}

The following functions are expected to work naturally with VecBasic and DenseMatrix
classes.
\itemize{
\item \code{[}, \code{[[}, \verb{[<-} and \verb{[[<-} for subsetting and assignment.
\item \code{dim()}, \verb{dim<-}, \code{length()}, \code{t()}, \code{det()}, \code{rbind()}, \code{cbind()}, \code{c()}, \code{rep()}
\item \code{\%*\%} for matrix multiplication
\item \code{solve(a, b)}: solve \code{a \%*\% x = b} where \code{a} is a square DenseMatrix and
\code{b} is a VecBasic/DenseMatrix.
\item \code{solve(a)}: find the inverse of \code{a} where \code{a} is a square DenseMatrix.
\item \code{solve(a, b)}: solve system of linear equations represented by \code{a} (VecBasic) with
regards to symbols in \code{b} (VecBasic).
}

Further, the R functions that work on Basic objects (e.g. \code{sin}) are expected work
on VecBasic and DenseMatrix objects as well in a vectorized manner.
}

\section{Function bindings}{


The following is a (incomplete) list of functions that are expected to work with
symengine objects. Note that these functions can also be used inside a formula or
R language objects and passed to \link{S} or \link{Basic} or \link{Vector} to construct symengine
objects. For example \code{S(~ sin(x) + 1)} and \code{S(quote(sin(x) + 1))}.
\itemize{
\item \code{+}, \code{-}, \code{*}, \code{/}, \code{^}
\item \code{abs}, \code{sqrt}, \code{exp}, \code{expm1}, \code{log}, \code{log10}, \code{log2}, \code{log1p}
\item \code{cos}, \code{cosh}, \code{sin}, \code{sinh}, \code{tan}, \code{tanh}, \code{acos}, \code{acosh}, \code{asin}, \code{asinh}, \code{atan}, \code{atanh}
\item \code{cospi}, \code{sinpi}, \code{tanpi}, \code{gamma}, \code{lgamma}, \code{digamma}, \code{trigamma}
\item \code{lambertw}, \code{zeta}, \code{dirichlet_eta}, \code{erf}, \code{erfc}
\item \code{atan2}, \code{kronecker_delta}, \code{lowergamma}, \code{uppergamma}, \code{psigamma}, \code{beta}
}
}

