% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAA_statistics_docs.R, R/B1statistic.R,
%   R/BHIstatistic.R, R/BHKstatistic.R, R/CHstatistic.R, R/CMstatistic.R,
%   R/K2Ustatistic.R, R/K2statistic.R, R/KSWstatistics.R, R/MGGstatistic.R,
%   R/MOIstatistic.R, R/MOKstatistic.R, R/Mstatistic.R, R/NAIstatistic.R,
%   R/NAKstatistic.R, R/S1statistic.R, R/S2statistic.R, R/T1statistic.R,
%   R/T2statistic.R
\name{TestStatistics}
\alias{TestStatistics}
\alias{B1}
\alias{BHI}
\alias{BHK}
\alias{CH}
\alias{CM}
\alias{K2U}
\alias{K2}
\alias{KS}
\alias{SGN}
\alias{WCX}
\alias{MGG}
\alias{MOI}
\alias{MOK}
\alias{M}
\alias{NAI}
\alias{NAK}
\alias{S1}
\alias{S2}
\alias{T1}
\alias{T2}
\title{Available test statistics for symmetry tests}
\usage{
B1(X)

BHI(X)

BHK(X)

CH(X)

CM(X)

K2U(X)

K2(X)

KS(X)

SGN(X)

WCX(X)

MGG(X)

MOI(X, k)

MOK(X, k)

M(X)

NAI(X, k)

NAK(X, k)

S1(X, k)

S2(X, k)

T1(X, k)

T2(X, k)
}
\arguments{
\item{X}{the numeric vector for which to calculate the test statistic}

\item{k}{the 'k' parameter in the formula (if applicable)}
}
\value{
The value of the test statistic.
}
\description{
The list of implemented test statistics and their functions
}
\details{
Below is a list of the implemented test statistics in the package. Each
statistic is listed by it's name, a code string (e.g. 'B1', CM','MOI') and
the formula of the statistic which is evaluated. The code string is used as
an argument to the \link{symmetry_test} function. Some statistics depend on a
parameter 'k' which can be seen from the formulas and is also passed as an
argument.

Each statistic is implemented as a function with the same name as the code
string, so the name of the function is passed as the argument "stat" to the
\link{symmetry_test} function
}
\section{Test statistics}{

The list of available statitics in the format "code(s) : name (reference)"
\itemize{
\item M : The Mira test statistic (see \insertCite{M}{symmetry})
\item CM : The Cabilio–Masaro test statistic (see \insertCite{CM}{symmetry})
\item MGG : The Miao, Gel and Gastwirth test statistic (see \insertCite{MGG}{symmetry})
\item B1 : The \eqn{\sqrt{b_1}} test statistic (see \insertCite{UNKcentre}{symmetry})
\item KS : The Kolmogorov--Smirnov test statistic (see \insertCite{UNKcentre}{symmetry})
\item SGN : The Sign test statistic (see \insertCite{UNKcentre}{symmetry})
\item KS : The Wilcoxon test statistic (see \insertCite{UNKcentre}{symmetry})
\item CH : The characterization based test statistic (see \insertCite{CH}{symmetry})
\item BHI : The Litvinova test statistic (see \insertCite{BHI}{symmetry})
\item BHK : The Baringhaus and Henze test statistic (see \insertCite{BHK}{symmetry})
\item MOI and MOK : The Milošević and Obradović test statistics (see \insertCite{MOIMOK}{symmetry})
\item NAI and NAK : The Nikitin and Ahsanullah test statistics (see \insertCite{NAINAK}{symmetry})
\item K2 and K2U : The Božin, Milošević, Nikitin and Obradović Kolmogorov type statistics based on V- and U- statistics respectively (see \insertCite{K2K2U}{symmetry})
\item T1, T2, S1 and S2 : The Allison and Pretorius test statistics (see \insertCite{Allison}{symmetry})
}
}

\references{
\insertAllCited{}
}
