/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import vcf.AL;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;

public final class HbdAL
implements AL {
    private final GL gl;

    public HbdAL(GL gL) {
        if (gL == null) {
            throw new NullPointerException("em==null");
        }
        this.gl = gL;
    }

    @Override
    public float al(int n, int n2, byte by) {
        if (by < 0 || by >= this.gl.marker(n).nAlleles()) {
            String string = "marker=" + n + " allele: " + by;
            throw new IllegalArgumentException(string);
        }
        int n3 = n2 / 2;
        return this.gl.gl(n, n3, by, by);
    }

    @Override
    public int nMarkers() {
        return this.gl.nMarkers();
    }

    @Override
    public Marker marker(int n) {
        return this.gl.marker(n);
    }

    @Override
    public Markers markers() {
        return this.gl.markers();
    }

    @Override
    public int nSamples() {
        return this.gl.nSamples();
    }

    @Override
    public Samples samples() {
        return this.gl.samples();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[HbdGL: nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        stringBuilder.append(Const.nl);
        stringBuilder.append(this.gl);
        stringBuilder.append(Const.nl);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

