/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.Const;
import blbutil.InputIterator;
import blbutil.StringUtil;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Utilities {
    private Utilities() {
    }

    public static String commandLine(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(stringArray.length * 20);
        long l = Runtime.getRuntime().maxMemory();
        stringBuilder.append(Const.nl);
        stringBuilder.append("Command line: java");
        if (l != Long.MAX_VALUE) {
            long l2 = l / 0x100000L;
            stringBuilder.append(" -Xmx");
            stringBuilder.append(l2);
            stringBuilder.append("m");
        }
        stringBuilder.append(" -jar ");
        stringBuilder.append(string);
        stringBuilder.append(Const.nl);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("  ");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(Const.nl);
        }
        return stringBuilder.toString();
    }

    public static void printMemoryUse(String string) {
        long l = 0x100000L;
        Runtime runtime = Runtime.getRuntime();
        System.out.println(Const.nl + string + '\t' + "maxMb=" + runtime.maxMemory() / l + '\t' + "totalMb=" + runtime.totalMemory() / l + '\t' + "freeMb=" + runtime.freeMemory() / l + '\t' + "usedMb=" + (runtime.totalMemory() - runtime.freeMemory()) / l);
    }

    public static String timeStamp() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm a z 'on' dd MMM yyyy");
        return simpleDateFormat.format(date);
    }

    public static Set<String> idSet(File file) {
        if (file == null) {
            return Collections.emptySet();
        }
        if (!file.exists()) {
            String string = "file does not exist: " + file;
            throw new IllegalArgumentException(string);
        }
        if (file.isDirectory()) {
            String string = "file is a directory: " + file;
            throw new IllegalArgumentException(string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        try (InputIterator inputIterator = InputIterator.fromGzipFile(file);){
            while (inputIterator.hasNext()) {
                String string = ((String)inputIterator.next()).trim();
                if (string.length() <= 0) continue;
                if (StringUtil.countFields(string) > 1) {
                    String string2 = "line has >1 white-space delimited fields: " + string;
                    throw new IllegalArgumentException(string2);
                }
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    public static void duoPrint(PrintWriter printWriter, String string) {
        System.out.print(string);
        printWriter.print(string);
    }

    public static void duoPrintln(PrintWriter printWriter, String string) {
        System.out.println(string);
        printWriter.println(string);
    }

    public static String elapsedMillis(long l) {
        return Utilities.elapsedNanos(1000000L * l);
    }

    public static String elapsedNanos(long l) {
        long l2;
        long l3 = Math.round((double)l / 1.0E9);
        StringBuilder stringBuilder = new StringBuilder(80);
        if (l3 >= 3600L) {
            l2 = l3 / 3600L;
            stringBuilder.append(l2);
            stringBuilder.append(l2 == 1L ? " hour " : " hours ");
            l3 %= 3600L;
        }
        if (l3 >= 60L) {
            l2 = l3 / 60L;
            stringBuilder.append(l2);
            stringBuilder.append(l2 == 1L ? " minute " : " minutes ");
            l3 %= 60L;
        }
        stringBuilder.append(l3);
        stringBuilder.append(l3 == 1L ? " second" : " seconds");
        return stringBuilder.toString();
    }

    public static String printElapsedTime(String string, long l) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 30);
        stringBuilder.append(string);
        stringBuilder.append(Utilities.elapsedMillis(l));
        stringBuilder.append(Const.nl);
        return stringBuilder.toString();
    }

    public static void exit(String string, Throwable throwable) {
        throwable.printStackTrace(System.err);
        System.err.println(throwable);
        System.err.println(string);
        System.err.println("terminating program.");
        System.exit(1);
    }

    public static void exit(String string) {
        System.out.println(string);
        System.out.println();
        System.out.flush();
        System.exit(0);
    }
}

