/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.ChromIds;
import blbutil.Filter;
import blbutil.FilterUtils;
import blbutil.InputIterator;
import blbutil.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import vcf.Marker;

public final class GeneticMap {
    private final int[][] basePos;
    private final double[][] genPos;

    private GeneticMap(List<List<String>> list) {
        this.basePos = new int[list.size()][];
        this.genPos = new double[list.size()][];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            List<String> list2 = list.get(i);
            this.basePos[i] = new int[list2.size()];
            this.genPos[i] = new double[list2.size()];
            GeneticMap.fillMapPositions(list2, this.basePos[i], this.genPos[i]);
        }
    }

    private static void fillMapPositions(List<String> list, int[] nArray, double[] dArray) {
        int n = list.size();
        assert (nArray.length == n && dArray.length == n);
        for (int i = 0; i < n; ++i) {
            String[] stringArray = StringUtil.getFields(list.get(i));
            if (stringArray.length != 4) {
                String string = "Map file format error: " + list.get(i);
                throw new IllegalArgumentException(string);
            }
            nArray[i] = Integer.parseInt(stringArray[3]);
            dArray[i] = Double.parseDouble(stringArray[2]);
            if (Double.isInfinite(dArray[i]) || Double.isNaN(dArray[i])) {
                String string = "invalid map position: " + dArray[i];
                throw new IllegalArgumentException(string);
            }
            if (i <= 0) continue;
            if (nArray[i] == nArray[i - 1]) {
                String string = "duplication position: " + list.get(i);
                throw new IllegalArgumentException(string);
            }
            if (nArray[i] >= nArray[i - 1] && !(dArray[i] < dArray[i - 1])) continue;
            String string = "map positions not in ascending order: " + list.get(i);
            throw new IllegalArgumentException(string);
        }
        if (n > 0 && dArray[0] == dArray[n - 1]) {
            String string = "constant map position: " + list.get(0);
            throw new IllegalArgumentException(string);
        }
    }

    public static GeneticMap fromPlinkMapFile(File file) {
        Filter<String> filter = FilterUtils.acceptAllFilter();
        return new GeneticMap(GeneticMap.divideByChrom(file, filter));
    }

    public static GeneticMap fromPlinkMapFile(File file, String string) {
        Filter<String> filter = FilterUtils.singletonFilter(string);
        return new GeneticMap(GeneticMap.divideByChrom(file, filter));
    }

    private static List<List<String>> divideByChrom(File file, Filter<String> filter) {
        int n = 200;
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>(25);
        try (InputIterator inputIterator = InputIterator.fromTextFile(file);){
            while (inputIterator.hasNext()) {
                String string;
                String string2 = (String)inputIterator.next();
                String[] stringArray = StringUtil.getFields(string2, 2);
                if (stringArray.length <= 0) continue;
                if (stringArray.length < 2) {
                    string = "Map file format error: " + string2;
                    throw new IllegalArgumentException(string);
                }
                string = stringArray[0];
                if (!filter.accept(string)) continue;
                int n2 = ChromIds.instance().indexOf(stringArray[0]);
                while (n2 >= arrayList.size()) {
                    arrayList.add(new ArrayList(n));
                }
                ((List)arrayList.get(n2)).add(string2);
            }
        }
        return arrayList;
    }

    public boolean hasMap(int n) {
        if (n < 0 || n >= this.basePos.length) {
            return false;
        }
        return this.basePos[n].length > 0;
    }

    public int nMapPositions(int n) {
        return this.hasMap(n) ? this.basePos[n].length : 0;
    }

    public int index2BasePos(int n, int n2) {
        if (!this.hasMap(n)) {
            throw new IllegalArgumentException("hasMap(chrom)==false");
        }
        return this.basePos[n][n2];
    }

    public double index2GenPos(int n, int n2) {
        if (!this.hasMap(n)) {
            throw new IllegalArgumentException("hasMap(chrom)==false");
        }
        return this.genPos[n][n2];
    }

    public int closestIndex(int n, int n2) {
        assert (this.basePos.length >= 2);
        int n3 = Arrays.binarySearch(this.basePos[n], n2);
        if (n3 >= 0) {
            return n3;
        }
        int n4 = -n3 - 1;
        if (n4 == 0) {
            return 0;
        }
        if (n4 == this.basePos.length) {
            return this.basePos.length - 1;
        }
        int n5 = this.basePos[n][n4] - n2;
        int n6 = n2 - this.basePos[n][n4 - 1];
        return n5 <= n6 ? n4 : n4 - 1;
    }

    public double genPos(Marker marker) {
        return this.genPos(marker.chromIndex(), marker.pos());
    }

    public double genPos(int n, int n2) {
        if (!this.hasMap(n)) {
            throw new IllegalArgumentException("hasMap(chrom)==false");
        }
        assert (this.basePos[n].length >= 2);
        assert (this.basePos[n].length == this.genPos[n].length);
        int n3 = Arrays.binarySearch(this.basePos[n], n2);
        if (n3 >= 0) {
            return this.genPos[n][n3];
        }
        int n4 = -n3 - 1;
        if (n4 == this.basePos[n].length) {
            --n4;
        } else if (n4 == 0) {
            ++n4;
        }
        int n5 = n2;
        int n6 = this.basePos[n][n4 - 1];
        int n7 = this.basePos[n][n4];
        double d = this.genPos[n][n4 - 1];
        double d2 = this.genPos[n][n4];
        return d + (double)((n5 - n6) / (n7 - n6)) * (d2 - d);
    }

    public int basePos(int n, double d) {
        if (!this.hasMap(n)) {
            throw new IllegalArgumentException("hasMap(chrom)==false");
        }
        assert (this.basePos[n].length >= 2);
        assert (this.basePos[n].length == this.genPos[n].length);
        int n2 = Arrays.binarySearch(this.genPos[n], d);
        if (n2 >= 0) {
            return this.basePos[n][n2];
        }
        int n3 = -n2 - 1;
        if (n3 == this.genPos[n].length) {
            --n3;
            while (this.genPos[n][n3] == this.genPos[n][n3 - 1]) {
                --n3;
            }
        } else if (n3 == 0) {
            ++n3;
            while (this.genPos[n][n3] == this.genPos[n][n3 - 1]) {
                ++n3;
            }
        }
        double d2 = d;
        double d3 = this.genPos[n][n3 - 1];
        double d4 = this.genPos[n][n3];
        int n4 = this.basePos[n][n3 - 1];
        int n5 = this.basePos[n][n3];
        return n4 + (int)Math.round((d2 - d3) / (d4 - d3) * (double)(n5 - n4));
    }

    public String toString() {
        return "main.GeneticMap";
    }
}

