/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Const;
import blbutil.FileIt;
import blbutil.FileUtil;
import blbutil.Filter;
import blbutil.InputIt;
import blbutil.IntArray;
import blbutil.Utilities;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import vcf.BrefIt;
import vcf.LowMafRefGT;
import vcf.Marker;
import vcf.RefIt;
import vcf.VcfEmission;
import vcf.VcfEmissionCompressor;
import vcf.VcfHeader;
import vcf.VcfWriter;

public class Bref {
    private static final String program = "bref.__REV__.jar";
    private static final int BUFFER_SIZE = 0x400000;
    private static final int SHIFT = 128;
    private static final int MAX_NSEQ = 255;
    private static final int STRING_BUFFER_SIZE = 300;
    private static final String[] bases = new String[]{"A", "C", "G", "T"};
    private static final Set<String> basesSet = Bref.basesSet();
    private static final String[][] snvPerms = Bref.snvPerms();
    private static final Comparator<String[]> allelesComp = Bref.allelesComparator();
    public static final int INITIAL_NUMBER = 223579146;
    public static final int EOF = 0;
    private final FileIt<String> it;
    private final DataOutputStream os;
    private final VcfHeader vcfHeader;
    private final BlockingQueue<String[]> stringBuffers;
    private final Function<String, VcfEmission> mapper;
    private final List<VcfEmission> emBuffer;
    private final VcfEmissionCompressor emCompressor;

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length != 1) {
            System.out.println(Bref.usage());
            System.exit(0);
        }
        if ((string = stringArray[0]).endsWith(".vcf") || string.endsWith(".vcf.gz")) {
            FileIt<String> fileIt = Bref.inputIterator(string);
            File file = Bref.brefFile(string);
            Bref bref = new Bref(fileIt, file);
        } else if (string.endsWith(".bref")) {
            File file = new File(string);
            try (PrintWriter printWriter = FileUtil.stdOutPrintWriter();){
                Bref.writeVcf(file, printWriter);
            }
        } else {
            System.out.println(Bref.usage());
            System.out.println("Unrecognized filename extension");
            System.exit(0);
        }
    }

    private static FileIt<String> inputIterator(String string) {
        if (string.endsWith(".vcf")) {
            return InputIt.fromTextFile(new File(string));
        }
        if (string.endsWith(".vcf.gz")) {
            return InputIt.fromGzipFile(new File(string));
        }
        throw new IllegalArgumentException("invalid filename");
    }

    private static File brefFile(String string) {
        int n = string.lastIndexOf(".vcf");
        assert (n >= 0);
        return new File(string.substring(0, n) + ".bref");
    }

    public static String[] alleleString(int n, int n2) {
        return Arrays.copyOf(snvPerms[n], n2);
    }

    private Bref(FileIt<String> fileIt, File file) {
        this.it = fileIt;
        this.os = Bref.dataOutputStream(file);
        this.vcfHeader = Bref.vcfHeader(fileIt);
        this.mapper = string -> RefIt.toRef.apply(this.vcfHeader, (String)string);
        this.stringBuffers = new ArrayBlockingQueue<String[]>(1);
        this.emBuffer = new ArrayList<VcfEmission>(500);
        this.emCompressor = new VcfEmissionCompressor(this.vcfHeader.samples(), 255);
        try {
            Bref.writeHeader(this.vcfHeader.sampleIds(), this.os);
            this.startFileReadingThread();
            this.writeCompressedRecords();
            this.os.writeInt(0);
            this.os.close();
        }
        catch (IOException iOException) {
            Utilities.exit("Error writing file", iOException);
        }
    }

    private static DataOutputStream dataOutputStream(File file) {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            outputStream = new GZIPOutputStream(outputStream, 0x400000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error opening: " + file, fileNotFoundException);
        }
        catch (IOException iOException) {
            Utilities.exit("IO error: " + file, iOException);
        }
        return new DataOutputStream(outputStream);
    }

    private static VcfHeader vcfHeader(FileIt<String> fileIt) {
        Filter<String> filter = Filter.acceptAllFilter();
        return new VcfHeader(fileIt, filter);
    }

    private static void writeHeader(String[] stringArray, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(223579146);
        dataOutputStream.writeUTF(program);
        dataOutputStream.writeInt(stringArray.length);
        for (String string : stringArray) {
            dataOutputStream.writeUTF(string);
        }
    }

    private void startFileReadingThread() {
        Runnable runnable = () -> {
            String string = Bref.readLine(this.it);
            int n = 300;
            while (string != null) {
                String string2 = Bref.chromFieldPlusTab(string);
                String[] stringArray = new String[n];
                int n2 = 0;
                while (string != null && n2 < n && string.startsWith(string2)) {
                    stringArray[n2++] = string;
                    string = Bref.readLine(this.it);
                }
                if (n2 < n) {
                    stringArray = Arrays.copyOf(stringArray, n2);
                }
                Bref.putInBlockingQueue(this.stringBuffers, stringArray);
            }
            Bref.putInBlockingQueue(this.stringBuffers, new String[0]);
        };
        new Thread(runnable).start();
    }

    private static String readLine(FileIt<String> fileIt) {
        if (!fileIt.hasNext()) {
            return null;
        }
        String string = (String)fileIt.next();
        if (string.trim().isEmpty()) {
            String string2 = "Blank line in VCF file: " + (fileIt.file() == null ? "stdin" : fileIt.file());
            throw new IllegalArgumentException(string2);
        }
        return string;
    }

    private static String chromFieldPlusTab(String string) {
        int n = string.indexOf(9);
        if (n == -1) {
            String string2 = "Missing tab delimiter: " + string;
            throw new IllegalArgumentException(string2);
        }
        return string.substring(0, n + 1);
    }

    private static <E> void putInBlockingQueue(BlockingQueue<E> blockingQueue, E e) {
        try {
            blockingQueue.put(e);
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("Error: InterruptedException", interruptedException);
        }
    }

    private static <E> E takeFromBlockingQueue(BlockingQueue<E> blockingQueue) {
        try {
            return blockingQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("Error: InterruptedException", interruptedException);
            assert (false);
            return null;
        }
    }

    private void writeCompressedRecords() throws IOException {
        int n = -1;
        while (n != 0) {
            String[] stringArray = Bref.takeFromBlockingQueue(this.stringBuffers);
            n = stringArray.length;
            if (stringArray.length <= 0) continue;
            List<VcfEmission> list = this.convertStringBuffer(stringArray);
            for (VcfEmission vcfEmission : list) {
                if (vcfEmission.storesNonMajorIndices()) {
                    this.emBuffer.add(vcfEmission);
                    continue;
                }
                if (vcfEmission.marker().nAlleles() > 255) {
                    this.emBuffer.add(new LowMafRefGT(vcfEmission.marker(), vcfEmission.samples(), Bref.hapIndices(vcfEmission)));
                    continue;
                }
                boolean bl = this.emCompressor.addToCompessedList(vcfEmission);
                if (!bl) {
                    this.writeAndClearVcfEmissions();
                    bl = this.emCompressor.addToCompessedList(vcfEmission);
                    assert (bl);
                }
                this.emBuffer.add(null);
            }
        }
        this.writeAndClearVcfEmissions();
    }

    private List<VcfEmission> convertStringBuffer(String[] stringArray) {
        return ((Stream)Arrays.stream(stringArray).parallel()).map(this.mapper).collect(Collectors.toList());
    }

    private static int[][] hapIndices(VcfEmission vcfEmission) {
        int[] nArray = Bref.alleleCounts(vcfEmission);
        int n = Bref.majorAllele(nArray);
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = i == n ? null : new int[nArray[i]];
        }
        int[] nArray2 = new int[nArray.length];
        int n2 = vcfEmission.nHaps();
        for (int i = 0; i < n2; ++i) {
            int n3 = vcfEmission.allele(i);
            if (n3 == n) continue;
            int n4 = n3;
            int n5 = nArray2[n4];
            nArray2[n4] = n5 + 1;
            nArrayArray[n3][n5] = i;
        }
        return nArrayArray;
    }

    private static int[] alleleCounts(VcfEmission vcfEmission) {
        int[] nArray = new int[vcfEmission.marker().nAlleles()];
        int n = vcfEmission.nHaps();
        for (int i = 0; i < n; ++i) {
            int n2 = vcfEmission.allele(i);
            nArray[n2] = nArray[n2] + 1;
        }
        return nArray;
    }

    private static int majorAllele(int[] nArray) {
        int n = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= nArray[n]) continue;
            n = i;
        }
        return n;
    }

    private void writeAndClearVcfEmissions() throws IOException {
        if (!this.emBuffer.isEmpty()) {
            int n;
            this.os.writeInt(this.emBuffer.size());
            this.os.writeUTF(Bref.chrom(this.emBuffer, this.emCompressor));
            this.os.writeByte(this.emCompressor.nSeq() - 128);
            IntArray intArray = this.emCompressor.hapToSeq();
            int n2 = intArray.size();
            for (n = 0; n < n2; ++n) {
                this.os.writeByte(intArray.get(n) - 128);
            }
            n = 0;
            for (VcfEmission vcfEmission : this.emBuffer) {
                if (vcfEmission == null) {
                    Bref.writeCompressedRecord(this.emCompressor, n++, this.os);
                    continue;
                }
                Bref.writeAlleleIndexRecord(vcfEmission, this.os);
            }
            this.emBuffer.clear();
            this.emCompressor.clear();
        }
    }

    private static String chrom(List<VcfEmission> list, VcfEmissionCompressor vcfEmissionCompressor) {
        if (vcfEmissionCompressor.size() > 0) {
            return vcfEmissionCompressor.marker(0).chrom();
        }
        if (list.size() > 0) {
            return list.get(0).marker().chrom();
        }
        throw new IllegalArgumentException();
    }

    private static void writeCompressedRecord(VcfEmissionCompressor vcfEmissionCompressor, int n, DataOutputStream dataOutputStream) throws IOException {
        Marker marker = vcfEmissionCompressor.marker(n);
        IntArray intArray = vcfEmissionCompressor.seqToAllele(n);
        Bref.writeMarker(marker, dataOutputStream);
        int n2 = 0;
        dataOutputStream.writeByte(n2);
        if (marker.nAlleles() <= 256) {
            int n3 = intArray.size();
            for (int i = 0; i < n3; ++i) {
                dataOutputStream.writeByte(intArray.get(i) - 128);
            }
        } else {
            int n4 = intArray.size();
            for (int i = 0; i < n4; ++i) {
                dataOutputStream.writeInt(intArray.get(i));
            }
        }
    }

    private static void writeAlleleIndexRecord(VcfEmission vcfEmission, DataOutputStream dataOutputStream) throws IOException {
        assert (vcfEmission.storesNonMajorIndices());
        int n = vcfEmission.nAlleles();
        int n2 = vcfEmission.majorAllele();
        Bref.writeMarker(vcfEmission.marker(), dataOutputStream);
        int n3 = 1;
        dataOutputStream.writeByte(n3);
        for (int i = 0; i < n; ++i) {
            if (i == n2) {
                dataOutputStream.writeInt(-1);
                continue;
            }
            dataOutputStream.writeInt(vcfEmission.alleleCount(i));
            for (int j = 0; j < vcfEmission.alleleCount(i); ++j) {
                dataOutputStream.writeInt(vcfEmission.hapIndex(i, j));
            }
        }
    }

    private static void writeMarker(Marker marker, DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeInt(marker.pos());
        int n2 = Math.min(marker.nIds(), 255);
        dataOutputStream.writeByte(n2 - 128);
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeUTF(marker.id(n));
        }
        n = Bref.isSNV(marker) ? (int)Bref.snvCode(marker.alleles()) : -1;
        dataOutputStream.writeByte(n);
        if (n == -1) {
            dataOutputStream.writeInt(marker.nAlleles());
            int n3 = marker.nAlleles();
            for (int i = 0; i < n3; ++i) {
                dataOutputStream.writeUTF(marker.allele(i));
            }
            dataOutputStream.writeInt(marker.end());
        }
    }

    private static byte snvCode(String[] stringArray) {
        int n = Arrays.binarySearch(snvPerms, stringArray, allelesComp);
        if (n < 0) {
            n = -n - 1;
        }
        int n2 = (n << 2) + (stringArray.length - 1);
        return (byte)n2;
    }

    private static boolean isSNV(Marker marker) {
        int n = marker.nAlleles();
        for (int i = 0; i < n; ++i) {
            if (basesSet.contains(marker.allele(i))) continue;
            return false;
        }
        return true;
    }

    private static void writeVcf(File file, PrintWriter printWriter) {
        try (BrefIt brefIt = new BrefIt(file);){
            if (brefIt.hasNext()) {
                VcfEmission vcfEmission = (VcfEmission)brefIt.next();
                VcfWriter.writeMetaLinesGT(vcfEmission.samples().ids(), program, printWriter);
                printWriter.println(vcfEmission.toString());
            }
            while (brefIt.hasNext()) {
                printWriter.println(((VcfEmission)brefIt.next()).toString());
            }
        }
    }

    private static Comparator<String[]> allelesComparator() {
        return (stringArray, stringArray2) -> {
            int n = Math.min(((String[])stringArray).length, ((String[])stringArray2).length);
            for (int i = 0; i < n; ++i) {
                char c;
                char c2 = stringArray[i].charAt(0);
                if (c2 == (c = stringArray2[i].charAt(0))) continue;
                return c2 < c ? -1 : 1;
            }
            if (((String[])stringArray).length != ((String[])stringArray2).length) {
                return ((String[])stringArray).length < ((String[])stringArray2).length ? -1 : 1;
            }
            return 0;
        };
    }

    private static String[][] snvPerms() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(24);
        Bref.permute(new String[0], bases, arrayList);
        return (String[][])arrayList.toArray((T[])new String[0][]);
    }

    private static Set<String> basesSet() {
        HashSet<String> hashSet = new HashSet<String>(4);
        hashSet.addAll(Arrays.asList(bases));
        return Collections.unmodifiableSet(hashSet);
    }

    private static void permute(String[] stringArray, String[] stringArray2, List<String[]> list) {
        if (stringArray2.length == 0) {
            list.add(stringArray);
        } else {
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3 = Arrays.copyOf(stringArray, stringArray.length + 1);
                stringArray3[stringArray.length] = stringArray2[i];
                String[] stringArray4 = new String[stringArray2.length - 1];
                if (i > 0) {
                    System.arraycopy(stringArray2, 0, stringArray4, 0, i);
                }
                if (i < stringArray4.length) {
                    System.arraycopy(stringArray2, i + 1, stringArray4, i, stringArray4.length - i);
                }
                Bref.permute(stringArray3, stringArray4, list);
            }
        }
    }

    private static String usage() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("usage: java -jar ");
        stringBuilder.append(program);
        stringBuilder.append(" [vcf]     (creates a .bref file)");
        stringBuilder.append(Const.nl);
        stringBuilder.append(" or");
        stringBuilder.append(Const.nl);
        stringBuilder.append("usage: java -jar ");
        stringBuilder.append(program);
        stringBuilder.append(" [bref]    (prints a .vcf file to standard out)");
        stringBuilder.append(Const.nl);
        stringBuilder.append(Const.nl);
        stringBuilder.append("where");
        stringBuilder.append(Const.nl);
        stringBuilder.append("  [vcf]  = A vcf file with phased, non-missing genotype data.  If the VCF");
        stringBuilder.append(Const.nl);
        stringBuilder.append("           file is a text file, its filename should end in \".vcf\".  If the");
        stringBuilder.append(Const.nl);
        stringBuilder.append("           VCF file is GZIP-compressed, its filename should end in \".vcf.gz\"");
        stringBuilder.append(Const.nl);
        stringBuilder.append("  [bref] = A binary reference file.  The filename should end in \".bref\"");
        stringBuilder.append(Const.nl);
        return stringBuilder.toString();
    }
}

