\name{plot.variofit}
\alias{plot.variofit}
\title{
Plot \code{variofit} objects
}
\description{
Plot \code{variofit} objects
}
\usage{
\method{plot}{variofit} (x, xlab = "Lag distance", ylab = "Variogram",
                         col.pts = "black", col.line = "red", 
                         pch = 21, \dots)                      
}
\arguments{
  \item{x}{
\code{variofit} object generated by \code{vario.fit} function
}
  \item{xlab}{
xlabel of the figure. Default is "Lag distance"
}
  \item{ylab}{
ylabel of the figure. Default is "Variogram"
}

\item{col.pts}{
Border color of the points. Default is black
}
\item{col.line}{
Color of the fitted variogram. Default is red
}
  \item{pch}{
Type of points to use when plotting the variogram. Default is 21
}
 \item{\dots}{
other graphical parameters.
}
}

\author{
Tarik C. Gouhier (tarik.gouhier@gmail.com)
}

\examples{
## Environmental variogram
data(pisco.data)
d=subset(pisco.data, subset=year==2000, select=c("latitude", "longitude", "upwelling"))
semiv=vario(data=d)
mod.sph=vario.fit(semiv$vario, semiv$mean.bin.dist)
plot(mod.sph)
}
