% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processes.R
\name{matern}
\alias{matern}
\title{The Matern covariance function}
\usage{
matern(x, y = NULL, nu = 1, rho = 1, sig = 1)
}
\arguments{
\item{x}{a vector}

\item{y}{If NULL, then y=x.}

\item{nu}{positive number specifying smoothness of the function.}

\item{rho}{scale parameter}

\item{sig}{magnitude parameter}
}
\value{
matrix of dimension length(x)*length(y), where the (i,j) entry of the matrix is the Matern covariance evaluated at the point (X(i),Y(j)).
}
\description{
The Matern covariance function
}
\details{
The precise definition of Matern covariance function can be found in see https://en.wikipedia.org/wiki/Matern_covariance_function.
}
