% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synoptclas.R
\name{synoptclas}
\alias{synoptclas}
\title{Synoptic classification}
\usage{
synoptclas(smode_data, ncomp, extreme_scores = 2)
}
\arguments{
\item{smode_data}{Data frame. S-mode data frame of the reanalysis variable. I.e. output obtained from \code{tidy_cuttime_nc} function.}

\item{ncomp}{Integer. Number of components to be retained.}

\item{extreme_scores}{Integer. Definition of extreme score threshold (Esteban et al., 2005). Default is 2.}
}
\value{
A list with: \itemize{
   \item{A data frame containing data grouped by circulation types ("grouped_data").}
   \item{An integer with the circulation types ("clas").}
   \item{A data frame containing the number and percentage of days assigned to each circulation type ("ct_freq").}
   \item{A data frame containing the number of days assigned to each circulation type by month ("monthly_freq").}
   \item{A data frame containing the number of days assigned to each circulation type by year ("annual_freq").}
   \item{The 'rotated' loadings matrix of class \code{"loadings"} ("rotated_loadings").}
   \item{The scores of the supplied data on the principal components ("scores").}
   \item{The coordinates of the scores used to perform the k-means clustering. For more information, read Esteban et al. (2005)("scores_coordinates").}
}
}
\description{
\code{synoptclas} establish a synoptic classification based on any atmospheric variable (i.e. mean sea level pressure, geoptential height at 500 hPa, etc.)
}
\details{
A PCA is applied to a S-mode matrix to reduce the dimension of the variables, in which the grid points are the variables and the days are the observations.
These principal components are subsequently rotated by means of a varimax rotation. With the rotated components, the scores are used to apply the extreme
scores method (Esteban et al., 2005). The scores show the degree of representativeness associated with the variation modes of each principal component, i.e.,
the classification of each day to its more representative centroid. Thus, the extreme scores method uses the scores > 2 and < -2, establishing a positive and
negative phase for each principal component. The extreme scores procedure establishes the number of groups and their centroids in order to apply the K-means
method without iterations.
}
\examples{
# Load data (mslp)
data(mslp)
# Converting our data into a S-mode, but without modifying time period
smode_mslp <- tidy_cuttime_nc(mslp, only_convert = TRUE)
# classification performance
smode_clas <- synoptclas(smode_mslp$smode_data, ncomp = 6)


}
\references{
{
Esteban, P. , Jones, P. D., MartC-nb
\emph{Atmospheric circulation patterns related to heavy snowfall days in Andorra, Pyrenees}
Int. J. Climatol. 25: 319-329. doi:10.1002/joc.1103
}
}
\seealso{
\code{\link{pca_decision}}
}
