% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_annealing.R
\name{calculate_TAE}
\alias{calculate_TAE}
\title{Calculate the total absolute error (TAE) between sample data and constraints.}
\usage{
calculate_TAE(sample_data, constraint_list, prior_sample_totals = NULL,
  dropped_obs_totals = NULL, new_obs = NULL)
}
\arguments{
\item{sample_data}{A \code{data.frame} with attributes matching \code{constraint_list}.}

\item{constraint_list}{A \code{list} of constraints. See \code{\link{add_constraint}}.}

\item{prior_sample_totals}{An optional \code{list} containing attribute counts of a prior sample 
corresponding to the constraint list. Defaults to \code{NULL}.}

\item{dropped_obs_totals}{An optional \code{list} containing attribute counts from the dropped 
observations in a prior sample. Defaults to \code{NULL}.}

\item{new_obs}{An optional \code{data.frame} containing new observations with attributes matching 
those in \code{sample_data}, \code{constraint_list}, and \code{prior_sample_totals}. Defaults 
to \code{NULL}.}
}
\description{
Calculates the total absolute error (TAE) between sample micro data and constraining
totals from the matching macro data. Allows for updating of prior TAE instead of re-calculating
to improve speed in iterating. The updating feature is particularly helpful for optimizing
micro data fitting via simulated annealing (see \code{\link{optimize_microdata}}).
}
\examples{
\dontrun{
## assumes that you have a micro_synthetic dataset named test_micro and attribute count
## named g respectively 
c_list <- add_constraint(attr_name= "gender", attr_totals= g, micro_data= test_micro,
            constraint_list= c_list)
calculate_TAE(test_micro, c_list)
}
}
