% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesizer.R
\name{synthesize}
\alias{synthesize}
\title{Create synthetic version of a dataset}
\usage{
synthesize(y, n = NROW(y))
}
\arguments{
\item{y}{\code{[vector|data.frame]} data to synthesize.}

\item{n}{\code{[integer]} Number of values or records to synthesize.}
}
\value{
A data object of the same type and structure as \code{y}.
}
\description{
Create \code{n} values or records based on the emperical (multivariate)
distribution of \code{y}.
}
\examples{
synthesize(cars$speed,10)
synthesize(cars)
synthesize(cars,25)

}
\seealso{
Other synthesis: 
\code{\link{make_synthesizer}()}
}
\concept{synthesis}
