% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.summary.R
\name{trakt.show.summary}
\alias{trakt.show.summary}
\title{Get show summary info}
\usage{
trakt.show.summary(target, extended = "min", force_data_frame = FALSE)
}
\arguments{
\item{target}{The \code{id} of the show requested. Either the \code{slug}
(e.g. \code{"game-of-thrones"}), \code{trakt id} or \code{IMDb id}. If multiple targets are
supplied, the results will be \code{rbind}ed together, automatically setting \code{force_data_frame}
to \code{TRUE}.}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}}

\item{force_data_frame}{If \code{TRUE}, the \code{list} is unnested as much as possible, resulting
in a flat \code{data.frame} suitable to be \code{rbind}ed to other summary results.}
}
\value{
A \code{list} or \code{data.frame} containing summary info
}
\description{
\code{trakt.show.summary} pulls show summary data and returns it compactly.
}
\details{
Note that setting \code{extended} to \code{min} makes this function
return about as much informations as \link[tRakt]{trakt.search}
}
\note{
See \href{http://docs.trakt.apiary.io/reference/shows/summary}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad.summary <- trakt.show.summary("breaking-bad")
}
}
\seealso{
Other show data: \code{\link{trakt.get_all_episodes}};
  \code{\link{trakt.get_full_showdata}};
  \code{\link{trakt.seasons.season}};
  \code{\link{trakt.seasons.summary}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.ratings}};
  \code{\link{trakt.show.watching}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}};
  \code{\link{trakt.stats}}
}

