% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.user.ratings.R
\name{trakt.user.ratings}
\alias{trakt.user.ratings}
\title{Get a user's ratings}
\usage{
trakt.user.ratings(user = getOption("trakt.username"), type = "shows",
  rating = NULL)
}
\arguments{
\item{user}{Target user. Defaults to \code{getOption("trakt.username")}}

\item{type}{Either \code{shows} (default) or \code{movies}}

\item{rating}{A rating to filter by. Can be \code{1} through \code{10}, default is \code{NULL}}
}
\value{
A \code{list} or \code{data.frame} containing stats.
}
\description{
\code{trakt.user.ratings} pulls a user's ratings
}
\note{
See \href{http://docs.trakt.apiary.io/reference/users/ratings/get-ratings}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
ratedshows  <- trakt.user.ratings()
ratedmovies <- trakt.user.ratings(type = "movies")
}
}
\seealso{
Other user: \code{\link{trakt.user.collection}};
  \code{\link{trakt.user.followers}};
  \code{\link{trakt.user.following}};
  \code{\link{trakt.user.friends}};
  \code{\link{trakt.user.stats}};
  \code{\link{trakt.user.watched}};
  \code{\link{trakt.user.watchlist}}
}

