% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hello.R
\name{scion}
\alias{scion}
\title{scion}
\usage{
scion(.data, ..., false_fun, false_name, false_env)
}
\arguments{
\item{.data}{A tbl or soomething that can be coerced into one}

\item{...}{conditions that will be passed to dplyr::filter}

\item{false_fun}{A function or functional that will be applied to the data that doesn't pass the supplied filters (the scion)}

\item{false_name}{optional, the name of the object to which the scion will be assigned. If specified, false_env must also be specified}

\item{false_env}{option, the environment into which the scion will be assigned. If specified, false_name must also be specified}
}
\value{
A tbl whose rows have passed the stated conditions
}
\description{
scion
}
\details{
.data will be split into two chunks based on the conditions. The scion will be passed through false_fun and then either placed on
the package's internal stack or assigned as specified by false_name and false_env.
}
\examples{
library(dplyr)
aframe <- data.frame(zed = runif(100))
set_to_zero <- . \%>\% mutate(zed = 0)
aframe \%>\% scion(zed >0.5, false_fun=set_to_zero) \%>\% mutate(zed=1) \%>\% graft
}
\author{
Seth Wenchel
}

