% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-mutate_sd.R
\name{mutate_sd}
\alias{mutate_sd}
\title{Mutate subset of data}
\usage{
mutate_sd(.data, .how = identity, ..., .SDcols,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE))
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{.how}{The function or function call that will perform the transformation.}

\item{...}{Possibly more arguments for \code{.how}.}

\item{.SDcols}{See \link[data.table:data.table]{data.table::data.table} and the details here.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}
}
\description{
Like \link{mutate-table.express} but for a single call and some \code{.SDcols}.
}
\details{
This function works similar to \code{\link[=transmute_sd]{transmute_sd()}} but keeps all columns and \emph{can} modify by
reference, like \link{mutate-table.express}.

Additionally, \code{.SDcols} supports \link[tidyselect:select_helpers]{tidyselect::select_helpers}, with the caveat that the
expression is evaluated eagerly, i.e. with the currently captured \code{data.table}. Consider using
\code{\link[=chain]{chain()}} to explicitly capture intermediate results as actual \code{data.table}s.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    mutate_sd(.COL * 2, .SDcols = c("mpg", "cyl"))

}
