% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqcut.R
\name{eqcut}
\alias{eqcut}
\alias{eqcut.default.labeling}
\title{Cut a continuous variable into equal-sized groups.}
\usage{
eqcut(
  x,
  ngroups,
  labeling = eqcut.default.labeling,
  withhold = NULL,
  varlabel = if (has.label(x)) label(x) else deparse(substitute(x)),
  quantile.type = 7,
  right = FALSE,
  ...
)

eqcut.default.labeling(x, xcat, which, what, from, to, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{ngroups}{The number of groups desired.}

\item{labeling}{A function that produces the category labels (see Details).}

\item{withhold}{A named list of logical vectors (see Details).}

\item{varlabel}{A character string to be used as a label for \code{x}, or
\code{NULL}.}

\item{quantile.type}{An integer from 1 to 9, passed as the \code{type} argument to function \code{\link[stats]{quantile}}.}

\item{right}{Should intervals be right-closed? (passed to \code{\link[base]{cut}}).}

\item{...}{Further arguments passed on to function \code{labeling}.}

\item{xcat}{A factor returned by \code{\link[base]{cut}}.}

\item{which, what}{Character vectors for labeling the categories in an
appropriate way (see Examples).}

\item{from, to}{Numeric vectors giving the ranges covered by the categories
of \code{x}.}
}
\value{
A \code{factor} of the same length as \code{x}. There are
\code{ngroups} levels plus one additional level for each element of
\code{withhold}.
}
\description{
Cut a continuous variable into equal-sized groups.
}
\details{
The function \code{labeling} must have the signature \code{function(x, xcat,
which, what, from, to, ...)} and produces the character vector of factor
levels. See below for an example.

The \code{withhold} list can be used when \code{x} contains special values
that should not be considered in the calculation of the quantiles used to
create the \code{ngroups} categories. The special values are given a label
that corresponds to the name of the corresponding list element. See below
for an example.
}
\section{Functions}{
\itemize{
\item \code{eqcut.default.labeling}: The default labeling function.
}}

\examples{
x <- sample(100)
table(eqcut(x, 2))
table(eqcut(x, 3))
table(eqcut(x, 4))
table(eqcut(x, 5))
table(eqcut(x, 6))
table(eqcut(x, 7))
table(eqcut(x, 8))

# An example of using eqcut in a table with custom labeling function.
dat <- expand.grid(id=1:100, sex=c("Male", "Female"), treat=c("Treated", "Placebo"))
dat$age <- runif(nrow(dat), 18, 50)
dat$wt <- exp(rnorm(nrow(dat), log(75 + 10*(dat$sex=="Male")), 0.2))
dat$auc <- ifelse(dat$treat=="Placebo", NA, exp(rnorm(nrow(dat), log(1000), 0.34)))
dat$auc[3] <- NA  # Add a missing value

label(dat$sex) <- "Sex"
label(dat$age) <- "Age"
label(dat$wt)  <- "Weight"
label(dat$auc) <- "AUC"
units(dat$age) <- "y"
units(dat$wt)  <- "kg"
units(dat$auc) <- "ng.h/mL"

w <- list(Placebo=(dat$treat=="Placebo"), Excluded=is.na(dat$auc))
f <- function(x, xcat, which, what, from, to, ...) {
   what <- sub("of ", "of<br/>", what)
   sprintf("\%s \%s<br/>&ge;\%s to &lt;\%s",
       which, what, signif_pad(from, 3, FALSE), signif_pad(to, 3, FALSE))
}
table1(~ sex + age + wt | eqcut(auc, 3, f, w), data=dat)

}
\seealso{
\code{\link[base]{cut}}
\code{\link[stats]{quantile}}
}
\keyword{utilities}
