% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_curve.R
\name{smooth_curve}
\alias{smooth_curve}
\title{Smooth Curve}
\usage{
smooth_curve(
  x,
  y,
  y_time = NULL,
  adj = NULL,
  fx = FALSE,
  strata = NULL,
  k = c(),
  split_var = NULL,
  div = c(),
  data
)
}
\arguments{
\item{x}{A string. The independent variable to be summarized given as a string.}

\item{y}{A string. The dependent variable to be summarized given as a string.}

\item{y_time}{A string. The survival time variable to be summarized given as a string.}

\item{adj}{A vector of strings. Moderator variables to be summarized given as a character vector.}

\item{fx}{Bool, default \code{= FALSE}.}

\item{strata}{A string. The paired variable to be summarized given as a string.}

\item{k}{A vector of integers, default \code{= c()}. Degree of freedom, It only works when \code{fx = TRUE}.}

\item{split_var}{A string, default \code{= NULL}. The split variables to be summarized given as a string.}

\item{div}{A numeric vector, default \code{= c()}. It only works when split_var is a continuous variable.}

\item{data}{A data frame in which these variables exist.}
}
\value{
An object about smooth curve.
}
\description{
Draw smooth curves. The four regression methods include general linear regression, logistic regression, conditional logistic regression and cox proportional hazards regression.
}
\examples{
## Load Mayo Clinic Primary Biliary Cirrhosis Data
library(survival)
library(tableeasy)
data(pbc)
## Check variables
head(pbc)
##The censored data is not discussed here
pbc_full <- subset(pbc,status!=0)
pbc_full$status <- pbc_full$status-1
## Make categorical variables factors
varsToFactor <- c('status','trt','ascites','hepato','spiders','edema','stage','sex')
pbc_full[varsToFactor] <- lapply(pbc_full[varsToFactor], factor)

## Moderator variables
adj_pbc <- c('age','alk.phos','ast')

## Smooth curve of General linear regression:
gam <- smooth_curve(x='albumin',
                    y='bili',
                    adj=adj_pbc,
                    data=pbc_full)
plot(gam$gam,se=TRUE,rug=TRUE,shift=gam$shift)


## Smooth curve of logistic regression:
gam <- smooth_curve(x = 'albumin',
                    y = 'status',
                    adj = adj_pbc,
                    split_var ='age',
                    div = c(45),
                    data = pbc_full)
plot(gam$gam[[1]],se=FALSE,rug=TRUE,xlim=c(2,4.5),ylab = 'Adjusted ln ORs for death')
oldpar <- par(new=TRUE)
plot(gam$gam[[2]],se=FALSE,rug=TRUE,xlim=c(2,4.5),ylab = 'Adjusted ln ORs for death',lty=2)
on.exit(par(oldpar))

## Smooth curve of conditional logistic regression:
pbc_full <- data.frame(pbc_full,'ytime'=1)
gam <- smooth_curve(x ='albumin',
                    y_time = 'ytime',
                    y = 'status',
                    adj = adj_pbc,
                    strata = 'trt',
                    data = pbc_full)

termplot(gam,term =c(1),col.term ="black",col.se = "black",se=TRUE,rug=FALSE,
           ylab="Log ORs for death")

## Smooth curve of Cox proportional hazards regression:
gam <- smooth_curve(x ='albumin',
                    y_time = 'time',
                    y = 'status',
                    adj = adj_pbc,
                    data = pbc_full)
termplot(gam,term =c(1),col.term ="black",col.se = "black",se=TRUE,rug=FALSE)
}
