% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Get and prepare input datasets (topo, labs, curve, correction)}
\usage{
get_data(
  region = NULL,
  topo = NULL,
  aggregate = FALSE,
  curve = NULL,
  correction = NULL,
  reclabs = NULL,
  units = list(topo = "m", curve = c(names = "yr", value = "m"), correction = "mm/yr"),
  buffer = NULL,
  fact = 0,
  verbose = FALSE
)
}
\arguments{
\item{region}{SpatVector. Region selection object defined by extent coordinates, a polygon object or path to dataset, an island, archipelago, country, mountain or plate name from the regions-list. If region is not defined a selection window will pop-up to define the area of interest.}

\item{topo}{SpatRaster. Topographic/Bathymetric model as SpatRaster or path to dataset. The topo projection is the reference for further outputs.}

\item{aggregate}{boolean. Whether to aggregate biogeographic shapes.}

\item{curve}{SpatRaster. Curve value, vector, grid or list of grids indicating the relative altitude of a biogeographic system per time period compared to the present. A typical example is a sea level curve indicating the relative sea level position above or below sea level compared to the present.}

\item{correction}{SpatRaster. Correction value, vector, grid, or list of grids to account for spatial-(non-)explicit and temporal (non-)linear changes in the topography (e.g., uplift and subsidence rates, sedimentation and erosion ticknesses)}

\item{reclabs}{character. Dataset or column used for labeling biogeographic shapes. By default the island labeling dataset is used, while if reclabs is set to ‘mnts’ the mountain labeling is used. Otherwise another column from the region object could be used, or a feature from the geonames feature list (e.g., ‘peaks’, ‘peak’) could be specified. Note that any overlapping name from the list geonames features cannot be used. If so, it is recommended to rename your labeling column. Note that in case of a user-defined reclabs column, the concerned column will be replicated in the labs-object under the column name ‘name’.}

\item{units}{numeric. Units of topo, curve and correction provided as a list (default: units=list(topo='m', curve=c(names='yr', value='m'), correction='mm/yr'))}

\item{buffer}{numeric. Draws a buffer around the selected region. For extent, the buffer is 0, otherwise 10000 m.}

\item{fact}{numeric. Spatial resolution factor at which the bathymetric model will be resampled}

\item{verbose}{boolean. FALSE: No messages are printed. TRUE: Standard verbose mode, providing progress bar. 2: Very verbose mode, displaying detailed information.}
}
\value{
a list including topo, labs, curve and correction input datasets
}
\description{
load and prepare input datasets topo, labs, curve and correction
}
\examples{

# load data samples
sporades <- sporades()
topo <- sporades$topo
labs <- sporades$labs
correction <- sporades$correction
curve <- sporades$curve

# subset first and last period 
curve <- curve[[c(1,dim(curve)[3])]]


data <- get_data(topo=topo, 
                 region=labs, 
                 curve=curve)
data <- get_data(topo=topo, 
                 region=labs, 
                 curve=curve, 
                 correction=correction)

# run reconstruct using prepared input datasets                  
rec <- reconstruct(data)


}
\author{
Johannes De Groeve
}
