% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot-bar.R
\docType{methods}
\name{plot_bar}
\alias{plot_bar}
\alias{seriographe}
\alias{Bertin}
\alias{Ford}
\alias{plot_bertin}
\alias{plot_bertin-method}
\alias{plot_ford}
\alias{plot_ford-method}
\alias{plot_bertin,CountMatrix-method}
\alias{plot_ford,CountMatrix-method}
\title{Bar Plot}
\usage{
plot_bertin(object, ...)

plot_ford(object, ...)

\S4method{plot_bertin}{CountMatrix}(object, threshold = NULL,
  scale = NULL)

\S4method{plot_ford}{CountMatrix}(object, EPPM = FALSE)
}
\arguments{
\item{object}{An object to be plotted.}

\item{...}{Currently not used.}

\item{threshold}{A \code{\link{function}} that takes a numeric vector as
argument and returns a numeric threshold value (see below).
If \code{NULL} (the default), no threshold is computed.}

\item{scale}{A \code{\link{function}} used to scale each variable,
that takes a numeric vector as argument and returns a numeric vector.
If \code{NULL} (the default), no scaling is performed.}

\item{EPPM}{A \code{\link{logical}} scalar: should the EPPM be drawn (see
details)?}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plots a Bertin, Ford (battleship curve) or Dice-Leraas diagram.
}
\section{Bertin Matrix}{

 As de Falguerolles \emph{et al.} (1997) points out:
 "In abstract terms, a Bertin matrix is a matrix
 of  displays. [...] To fix ideas, think of a data matrix, variable by case,
 with real valued variables. For each variable, draw a bar chart of variable
 value by case. High-light all bars representing a value above some sample
 threshold for that variable."
}

\section{Ford Diagram}{

 If \code{EPPM} is \code{TRUE} and if a relative abundance is greater than
 the mean percentage of the type, the exceeding part is highlighted.
 This positive difference from the column mean percentage (in french "écart
 positif au pourcentage moyen", EPPM) represents a deviation from the
 situation of statistical independence. As independence can be interpreted as
 the absence of relationships between types and the chronological order of
 the assemblages, \code{EPPM} is a useful graphical tool to explore
 significance of relationship between rows and columns related to
 \code{\link[=seriate]{seriation}} (Desachy 2004).
}

\examples{
## Abundance data
## Coerce dataset to a count matrix
mississippi_count <- as_count(mississippi)

## Plot a Bertin diagram...
## ...without threshold
plot_bertin(mississippi_count, threshold = NULL)
## ...with the variable mean as threshold
plot_bertin(mississippi_count, threshold = mean)

## ...with variables scaled to 0-1
scale_01 <- function(x) (x - min(x)) / (max(x) - min(x))
plot_bertin(mississippi_count, threshold = mean, scale = scale_01)

## Abundance data
## Coerce dataset to a count matrix (data from Desachy 2004)
compiegne_count <- as_count(compiegne)

## Plot a Ford diagram...
## ...without threshold
plot_ford(compiegne_count)
## ...with EPPM
plot_ford(compiegne_count, EPPM = TRUE)
}
\references{
Bertin, J. (1977). \emph{La graphique et le traitement graphique de
 l'information}. Paris: Flammarion. Nouvelle Bibliothèque Scientifique.

 de Falguerolles, A., Friedrich, F. & Sawitzki, G. (1997). A Tribute to J.
 Bertin's Graphical Data Analysis. In W. Badilla & F. Faulbaum (eds.),
 \emph{SoftStat '97: Advances in Statistical Software 6}. Stuttgart: Lucius
 & Lucius, p. 11-20.

 Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
 graphique pour tableaux de comptages. \emph{Revue archéologique de
 Picardie}, 3(1), 39-56.
 DOI: \href{https://doi.org/10.3406/pica.2004.2396}{10.3406/pica.2004.2396}.

 Ford, J. A. (1962). \emph{A quantitative method for deriving cultural
 chronology}. Washington, DC: Pan American Union. Technical manual 1.
}
\seealso{
Other plot: \code{\link{plot_date}},
  \code{\link{plot_line}}, \code{\link{plot_matrix}},
  \code{\link{plot_spot}}
}
\author{
N. Frerebeau
}
\concept{plot}
