% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_similarity.R
\docType{methods}
\name{similarity}
\alias{similarity}
\alias{similarity-method}
\alias{similarity,CountMatrix-method}
\alias{similarity,IncidenceMatrix-method}
\title{Similarity}
\usage{
similarity(object, ...)

\S4method{similarity}{CountMatrix}(
  object,
  method = c("brainerd", "bray", "jaccard", "morisita", "sorenson", "binomial"),
  ...
)

\S4method{similarity}{IncidenceMatrix}(object, method = c("jaccard", "sorenson"), ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} matrix of count data.}

\item{...}{Further arguments to be passed to internal methods.}

\item{method}{A \code{\link{character}} string specifying the method to be
used (see details). Any unambiguous substring can be given.}
}
\value{
\code{similarity} returns a \code{\link[stats]{dist}} object.
}
\description{
Similarity
}
\details{
\eqn{\beta}-diversity can be measured by addressing \emph{similarity}
 between pairs of samples/cases (Brainerd-Robinson, Jaccard, Morisita-Horn
 and Sorenson indices). Similarity between pairs of taxa/types can be
 measured by assessing the degree of co-occurrence (binomial co-occurrence).

 Jaccard, Morisita-Horn and Sorenson indices provide a scale of similarity
 from \code{0}-\code{1} where \code{1} is perfect similarity and \code{0} is
 no similarity. The Brainerd-Robinson index is scaled between \code{0} and
 \code{200}. The Binomial co-occurrence assessment approximates a Z-score.
 \describe{
  \item{binomial}{Binomial co-occurrence assessment. This assesses the degree
  of co-occurrence between taxa/types within a dataset. The strongest
  associations are shown by large positive numbers, the strongest
  segregations by large negative numbers.}
  \item{brainerd}{Brainerd-Robinson quantitative index. This is a city-block
  metric of similarity between pairs of samples/cases.}
  \item{bray}{Sorenson quantitative index (Bray and Curtis modified version
  of the Sorenson index).}
  \item{jaccard}{Jaccard qualitative index.}
  \item{morisita}{Morisita-Horn quantitative index.}
  \item{sorenson}{Sorenson qualitative index.}
 }
}
\examples{
## Data from Huntley 2008
ceramics <- CountMatrix(
  data = c(16, 9, 3, 0, 1,
           13, 3, 2, 0, 0,
           9, 5, 2, 5, 0,
           14, 12, 3, 0, 0,
           0, 26, 4, 0, 0,
           1, 26, 4, 0, 0,
           0, 11, 3, 13, 0,
           0, 0, 17, 0, 16,
           0, 0, 18, 0, 14),
  nrow = 9, byrow = TRUE
)
rownames(ceramics) <- c("Atsinna", "Cienega", "Mirabal", "PdMuertos",
                        "Hesh", "LowPesc", "BoxS", "Ojo Bon", "S170")
colnames(ceramics) <- c("DLH-1", "DLH-2a", "DLH-2b", "DLH-2c", "DLH-4")

## Brainerd-Robinson measure (count data)
C <- similarity(ceramics, "brainerd")
plot_spot(C)

## Data from Magurran 1988, p. 166
data("birds", package = "folio")

## Plot spot diagram
birds <- as_count(birds)

## Jaccard measure (presence/absence data)
similarity(birds, "jaccard") # 0.46

## Sorenson measure (presence/absence data)
similarity(birds, "sorenson") # 0.63

# Jaccard measure (Bray's formula ; count data)
similarity(birds, "bray") # 0.44

# Morisita-Horn measure (count data)
similarity(birds, "morisita") # 0.81
}
\references{
Brainerd, G. W. (1951). The Place of Chronological Ordering in
 Archaeological Analysis. \emph{American Antiquity}, 16(04), 301-313.
 \doi{10.2307/276979}.

 Bray, J. R. & Curtis, J. T. (1957). An Ordination of the Upland Forest
 Communities of Southern Wisconsin. \emph{Ecological Monographs}, 27(4),
 325-349. \doi{10.2307/1942268}.

 Kintigh, K. (2006). Ceramic Dating and Type Associations. In J. Hantman and
 R. Most (eds.), \emph{Managing Archaeological Data: Essays in Honor of
 Sylvia W. Gaines}. Anthropological Research Paper, 57. Tempe, AZ: Arizona
 State University, p. 17-26.

 Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
 Princeton, NJ: Princeton University Press. \doi{10.1007/978-94-015-7358-0}.

 Robinson, W. S. (1951). A Method for Chronologically Ordering Archaeological
 Deposits. \emph{American Antiquity}, 16(04), 293-301. \doi{10.2307/276978}.
}
\seealso{
Other diversity: 
\code{\link{heterogeneity-index}},
\code{\link{richness-index}},
\code{\link{turnover-index}}
}
\author{
N. Frerebeau
}
\concept{diversity}
