% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_rarefaction.R
\docType{methods}
\name{rarefaction}
\alias{rarefaction}
\alias{rarefaction-method}
\alias{index_hurlbert}
\alias{index_hurlbert-method}
\alias{rarefaction,matrix-method}
\alias{rarefaction,data.frame-method}
\alias{index_hurlbert,numeric-method}
\title{Rarefaction}
\usage{
rarefaction(object, ...)

index_hurlbert(x, ...)

\S4method{rarefaction}{matrix}(object, sample = NULL, method = c("hurlbert"), step = 1)

\S4method{rarefaction}{data.frame}(object, sample = NULL, method = c("hurlbert"), step = 1)

\S4method{index_hurlbert}{numeric}(x, sample, ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{sample}{A length-one \code{\link{numeric}} vector giving the sub-sample size.
The size of sample should be smaller than total community size.}

\item{method}{A \code{\link{character}} string or vector of strings specifying the
index to be computed (see details). Any unambiguous substring can be given.}

\item{step}{An \code{\link{integer}} giving the increment of the sample size.}
}
\value{
\itemize{
\item \code{rarefaction()} returns a \linkS4class{RarefactionIndex} object.
\item \verb{index_*()} return a \code{\link{numeric}} vector.
}
}
\description{
Computes Hurlbert's unbiased estimate of Sander's rarefaction.
}
\section{Details}{

The number of different taxa, provides an instantly comprehensible
expression of diversity. While the number of taxa within a sample
is easy to ascertain, as a term, it makes little sense: some taxa
may not have been seen, or there may not be a fixed number of taxa
(e.g. in an open system; Peet 1974). As an alternative, \emph{richness}
(\eqn{S}) can be used for the concept of taxa number (McIntosh 1967).

It is not always possible to ensure that all sample sizes are equal
and the number of different taxa increases with sample size and
sampling effort (Magurran 1988). Then, \emph{rarefaction} (\eqn{E(S)}) is
the number of taxa expected if all samples were of a standard size (i.e.
taxa per fixed number of individuals). Rarefaction assumes that imbalances
between taxa are due to sampling and not to differences in actual
abundances.
}

\examples{
## Richness
## Margalef and Menhinick index
## Data from Magurran 1988, p. 128-129
trap <- matrix(data = c(9, 3, 0, 4, 2, 1, 1, 0, 1, 0, 1, 1,
                        1, 0, 1, 0, 0, 0, 1, 2, 0, 5, 3, 0),
               nrow = 2, byrow = TRUE, dimnames = list(c("A", "B"), NULL))
richness(trap, method = "margalef") # 2.55 1.88
richness(trap, method = "menhinick") # 1.95 1.66

## Asymptotic species richness
## Chao1-type estimators
## Data from Chao & Chiu 2016
brazil <- matrix(
  data = rep(x = c(1:21, 23, 25, 27, 28, 30, 32, 34:37, 41,
                   45, 46, 49, 52, 89, 110, 123, 140),
             times = c(113, 50, 39, 29, 15, 11, 13, 5, 6, 6, 3, 4,
                       3, 5, 2, 5, 2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1,
                       0, 0, 2, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0)),
  nrow = 1, byrow = TRUE
)

composition(brazil, method = c("chao1"), unbiased = FALSE) # 461.625
composition(brazil, method = c("ace"), k = 10) # 445.822

## Rarefaction
rarefaction(trap, sample = 13) # 6.56 6.00
}
\references{
Hurlbert, S. H. (1971). The Nonconcept of Species Diversity: A Critique and
Alternative Parameters. \emph{Ecology}, 52(4), 577-586.
\doi{10.2307/1934145}.

Sander, H. L. (1968). Marine Benthic Diversity: A Comparative Study.
\emph{The American Naturalist}, 102(925), 243-282.
}
\seealso{
Other diversity measures: 
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot_diversity}},
\code{\link{richness}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
