% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_beta.R
\docType{methods}
\name{index_wilson}
\alias{index_wilson}
\alias{index_wilson-method}
\alias{index_wilson,matrix-method}
\title{Wilson Measure}
\usage{
index_wilson(x, ...)

\S4method{index_wilson}{matrix}(x)
}
\arguments{
\item{x}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} of count data
(absolute frequencies, i.e. a contingency table).}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Wilson Measure
}
\details{
This assumes that the order of the matrix rows (from \eqn{1} to \eqn{n})
follows the progression along the gradient/transect.
}
\references{
Wilson, M. V., & Shmida, A. (1984). Measuring Beta Diversity with
Presence-Absence Data. \emph{The Journal of Ecology}, 72(3), 1055-1064.
\doi{10.2307/2259551}.
}
\seealso{
Other beta diversity measures: 
\code{\link{index_binomial}()},
\code{\link{index_brainerd}()},
\code{\link{index_bray}()},
\code{\link{index_cody}()},
\code{\link{index_jaccard}()},
\code{\link{index_morisita}()},
\code{\link{index_routledge}},
\code{\link{index_sorenson}()},
\code{\link{index_whittaker}()}
}
\author{
N. Frerebeau
}
\concept{beta diversity measures}
