/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.jpeg2000.impl;

import com.github.jaiimageio.jpeg2000.impl.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HeaderBox
extends Box {
    private static String[] elementNames = new String[]{"Height", "Width", "NumComponents", "BitDepth", "CompressionType", "UnknownColorspace", "IntellectualProperty"};
    private int width;
    private int height;
    private short numComp;
    private byte bitDepth;
    private byte compressionType;
    private byte unknownColor;
    private byte intelProp;

    public static String[] getElementNames() {
        return elementNames;
    }

    public HeaderBox(int height, int width, int numComp, int bitDepth, int compressionType, int unknownColor, int intelProp) {
        super(22, 1768449138, null);
        this.height = height;
        this.width = width;
        this.numComp = (short)numComp;
        this.bitDepth = (byte)bitDepth;
        this.compressionType = (byte)compressionType;
        this.unknownColor = (byte)unknownColor;
        this.intelProp = (byte)intelProp;
    }

    public HeaderBox(byte[] data) {
        super(8 + data.length, 1768449138, data);
    }

    public HeaderBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("Height".equals(name)) {
                this.height = Box.getIntElementValue(child);
            }
            if ("Width".equals(name)) {
                this.width = Box.getIntElementValue(child);
            }
            if ("NumComponents".equals(name)) {
                this.numComp = Box.getShortElementValue(child);
            }
            if ("BitDepth".equals(name)) {
                this.bitDepth = Box.getByteElementValue(child);
            }
            if ("CompressionType".equals(name)) {
                this.compressionType = Box.getByteElementValue(child);
            }
            if ("UnknownColorspace".equals(name)) {
                this.unknownColor = Box.getByteElementValue(child);
            }
            if (!"IntellectualProperty".equals(name)) continue;
            this.intelProp = Box.getByteElementValue(child);
        }
    }

    @Override
    protected void parse(byte[] data) {
        this.height = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        this.width = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        this.numComp = (short)((data[8] & 0xFF) << 8 | data[9] & 0xFF);
        this.bitDepth = data[10];
        this.compressionType = data[11];
        this.unknownColor = data[12];
        this.intelProp = data[13];
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public short getNumComponents() {
        return this.numComp;
    }

    public byte getCompressionType() {
        return this.compressionType;
    }

    public byte getBitDepth() {
        return this.bitDepth;
    }

    public byte getUnknownColorspace() {
        return this.unknownColor;
    }

    public byte getIntellectualProperty() {
        return this.intelProp;
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    @Override
    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[14];
        HeaderBox.copyInt(this.data, 0, this.height);
        HeaderBox.copyInt(this.data, 4, this.width);
        this.data[8] = (byte)(this.numComp >> 8);
        this.data[9] = (byte)(this.numComp & 0xFF);
        this.data[10] = this.bitDepth;
        this.data[11] = this.compressionType;
        this.data[12] = this.unknownColor;
        this.data[13] = this.intelProp;
    }
}

