% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_page_dims.R
\name{get_page_dims}
\alias{get_page_dims}
\alias{get_n_pages}
\title{Page length and dimensions}
\usage{
get_page_dims(file, doc, pages = NULL, password = NULL, copy = FALSE)

get_n_pages(file, doc, password = NULL, copy = FALSE)
}
\arguments{
\item{file}{A character string specifying the path or URL to a PDF file.}

\item{doc}{Optionally,, in lieu of \code{file}, an rJava reference to a PDDocument Java object.}

\item{pages}{An optional integer vector specifying pages to extract from.}

\item{password}{Optionally, a character string containing a user password to access a secured PDF.}

\item{copy}{Specifies whether the original local file(s) should be copied to
\code{tempdir()} before processing. \code{FALSE} by default. The argument is
ignored if \code{file} is URL.}
}
\value{
For \code{get_n_pages}, an integer. For \code{get_page_dims}, a list of two-element numeric vectors specifying the width and height of each page, respectively.
}
\description{
Get Page Length and Dimensions
}
\details{
\code{get_n_pages} returns the page length of a PDF document. \code{get_page_dims} extracts the dimensions of specified pages in a PDF document. This can be useful for figuring out how to specify the \code{area} argument in \code{\link{extract_tables}}
}
\examples{
\donttest{
# simple demo file
f <- system.file("examples", "data.pdf", package = "tabulizer")

get_n_pages(file = f)
get_page_dims(f)
}
}
\references{
\href{http://tabula.technology/}{Tabula}
}
\seealso{
\code{\link{extract_tables}}, \code{\link{extract_text}}, \code{\link{make_thumbnails}}
}
\author{
Thomas J. Leeper <thosjleeper@gmail.com>
}
