% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_traceback.R
\name{tar_traceback}
\alias{tar_traceback}
\title{Get a target's traceback}
\usage{
tar_traceback(name, envir = parent.frame(), packages = TRUE, source = TRUE)
}
\arguments{
\item{name}{Symbol, name of the target whose workspace to read.}

\item{envir}{Environment in which to put the objects.}

\item{packages}{Logical, whether to load the required packages
of the target.}

\item{source}{Logical, whether to run \verb{_targets.R} to load user-defined
global object dependencies into \code{envir}. If \code{TRUE}, then \code{envir}
should either be the global environment or inherit from the
global environment.}
}
\value{
Character vector, the traceback of a failed target
if it exists
}
\description{
If a target ran with \code{error = "workspace"} and errored out,
\code{tar_traceback()} returns its traceback. The workspace file must
exist. For more information, see \code{\link[=tar_workspace]{tar_workspace()}}.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tmp <- sample(1)
tar_script({
  tar_option_set(error = "workspace")
  list(
    tar_target(x, "loaded"),
    tar_target(y, stop(x))
  )
}, ask = FALSE)
try(tar_make())
tar_traceback(y)
})
}
}
