% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_cue.R
\name{tar_cue}
\alias{tar_cue}
\title{Declare the rules that cue a target.}
\usage{
tar_cue(
  mode = c("thorough", "always", "never"),
  command = TRUE,
  depend = TRUE,
  format = TRUE,
  iteration = TRUE,
  file = TRUE
)
}
\arguments{
\item{mode}{Cue mode. If \code{"thorough"}, all the cues apply unless
individually suppressed. If \code{"always"}, then the target always
runs. If \code{"never"}, then the target does not run unless the
metadata does not exist or the last run errored.}

\item{command}{Logical, whether to rerun the target if command changed
since last time.}

\item{depend}{Logical, whether to rerun the target if the value of one
of the dependencies changed.}

\item{format}{Logical, whether to rerun the target if the user-specified
storage format changed. The storage format is user-specified through
\code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}.}

\item{iteration}{Logical, whether to rerun the target if the user-specified
iteration method changed. The iteration method is user-specified through
\code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}.}

\item{file}{Logical, whether to rerun the target if the file(s) with the
return value changed or at least one is missing.}
}
\description{
Declare the rules that mark a target as outdated.
}
\details{
\code{targets} uses internal metadata and special cues
to decide if a target is up to date.
A target is outdated if one of the following cues is met
(checked in the order given below). \code{tar_cue()} can activate
or suppress many of these cues. See the user manual for details.
\enumerate{
\item There is no metadata record of the target.
\item The target errored last run.
\item The target has a different class than it did before.
\item The cue mode equals \code{"always"}.
\item The cue mode does not equal \code{"never"}.
\item The \code{command} metadata field (the hash of the R command)
is different from last time.
\item The \code{depend} metadata field (the hash of the immediate upstream
dependency targets and global objects) is different from last time.
\item The storage format is different from last time.
\item The iteration mode is different from last time.
\item A target's file (either the one in \verb{_targets/objects/}
or a dynamic file) does not exist or changed since last time.
}

A target's dependencies can include functions, and these functions are
tracked for changes using a custom hashing procedure. When a function's
hash changes, the function is considered invalidated, and so are any
downstream targets with the \code{depend} cue turned on. The
\code{targets} package computes the hash of a function in the following way.
\enumerate{
\item Deparse the function with \code{targets:::deparse_safe()}. This
function computes a string representation of the function
that removes comments and standardizes whitespace so that
trivial changes to formatting do not cue targets to rerun.
\item Manually remove any literal pointers from the function string
using \code{targets:::mask_pointers()}. Such pointers arise from
inline compiled C/C++ functions.
\item Compute a hash on the preprocessed string above using
\code{targets:::digest_chr64()}.
}

Those functions themselves have dependencies, and those dependencies
are detected with \code{codetools::findGlobals()}.
Dependencies of functions may include other global functions or
global objects. If a dependency of a function is invalidated,
the function itself is invalidated, and so are any dependent
targets with the \code{depend} cue turned on.
}
\examples{
# The following target will always run when the pipeline runs.
x <- tar_target(x, download_data(), cue = tar_cue(mode = "always"))
}
\seealso{
Other targets: 
\code{\link{tar_target_raw}()},
\code{\link{tar_target}()}
}
\concept{targets}
