% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_pid.R
\name{tar_pid}
\alias{tar_pid}
\title{Get main process ID.}
\usage{
tar_pid()
}
\value{
Integer with the process ID (PID) of the most recent
main R process to orchestrate the targets of the current project.
}
\description{
Get the process ID (PID) of the most recent main R process
to orchestrate the targets of the current project.
}
\details{
The main process is the R process invoked
by \code{\link[=tar_make]{tar_make()}} or similar. If \code{callr_function} is not \code{NULL},
this is an external process, and the \code{pid} in the return value
will not agree with \code{Sys.getpid()} in your current interactive session.
The process may or may not be alive. You may want to
check it with \code{ps::ps_is_running(ps::ps_handle(targets::tar_pid()))}
before running another call to \code{\link[=tar_make]{tar_make()}}
for the same project.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
Sys.getpid()
tar_pid() # Different from the current PID.
})
}
}
\seealso{
Other data: 
\code{\link{tar_load_raw}()},
\code{\link{tar_load}()},
\code{\link{tar_meta}()},
\code{\link{tar_objects}()},
\code{\link{tar_process}()},
\code{\link{tar_read_raw}()},
\code{\link{tar_read}()}
}
\concept{data}
