% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_progress_summary.R
\name{tar_progress_summary}
\alias{tar_progress_summary}
\title{Summarize target progress.}
\usage{
tar_progress_summary(
  fields = c("started", "built", "errored", "canceled", "since")
)
}
\arguments{
\item{fields}{Optional, names of progress data columns to read.
Set to \code{NULL} to read all fields.}
}
\value{
A data frame with one row and the following
optional columns that can be selected with \code{fields}.
(\code{time} is omitted by default.)
\itemize{
\item \code{started}: number of targets that started and did not (yet) finish.
\item \code{built}: number of targets that completed without error or cancellation.
\item \code{errored}: number of targets that threw an error.
\item \code{canceled}: number of canceled targets (see \code{\link[=tar_cancel]{tar_cancel()}}).
\item \code{since}: how long ago progress last changed (\code{Sys.time() - time}).
\item \code{time}: the time when the progress last changed
(modification timestamp of the \verb{_targets/meta/progress} file).
}
}
\description{
Summarize the progress of a run of the pipeline.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, x, pattern = map(x)),
    tar_target(z, stopifnot(y < 1.5), pattern = map(y), error = "continue")
  )
}, ask = FALSE)
try(tar_make())
tar_progress_summary()
})
}
}
\seealso{
Other progress: 
\code{\link{tar_poll}()},
\code{\link{tar_progress_branches}()},
\code{\link{tar_progress}()},
\code{\link{tar_watch_server}()},
\code{\link{tar_watch_ui}()},
\code{\link{tar_watch}()}
}
\concept{progress}
