% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_meta_delete.R
\name{tar_meta_delete}
\alias{tar_meta_delete}
\title{Delete metadata.}
\usage{
tar_meta_delete(
  meta = TRUE,
  progress = TRUE,
  process = TRUE,
  crew = TRUE,
  verbose = TRUE,
  delete = "all",
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{meta}{Logical of length 1, whether to process the main metadata file
at \verb{_targets/meta/meta}.}

\item{progress}{Logical of length 1, whether to process the progress file at
\verb{_targets/meta/progress}.}

\item{process}{Logical of length 1, whether to process the process file at
\verb{_targets/meta/process}.}

\item{crew}{Logical of length 1, whether to process the \code{crew} file at
\verb{_targets/meta/crew}. Only exists if running \code{targets} with \code{crew}.}

\item{verbose}{Logical of length 1, whether to print informative
console messages.}

\item{delete}{Character of length 1, which location to delete the files.
Choose \code{"local"} for local files, \code{"cloud"} for files on the cloud,
or \code{"all"} to delete metadata files from both the local file system
and the cloud.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\description{
Delete the project metadata files from the local file system,
the cloud, or both.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
}, ask = FALSE)
tar_make()
tar_meta_delete()
})
}
}
\seealso{
Other metadata: 
\code{\link{tar_meta_download}()},
\code{\link{tar_meta_sync}()},
\code{\link{tar_meta_upload}()},
\code{\link{tar_meta}()}
}
\concept{metadata}
